/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.test;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObjectSupport;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.groovy.dsl.actions.ActionsBuilder;
import org.citrusframework.groovy.dsl.actions.FinallyActionsBuilder;
import org.citrusframework.groovy.dsl.configuration.ContextConfiguration;
import org.citrusframework.groovy.dsl.test.VariablesConfiguration;

public class TestCaseScript
extends GroovyObjectSupport
implements ActionsBuilder {
    private final Citrus citrus;
    private final TestCaseRunner runner;
    private final TestContext context;
    private final String basePath;

    public TestCaseScript(Citrus citrus, TestCaseRunner runner, TestContext context, String basePath) {
        this.citrus = citrus;
        this.runner = runner;
        this.context = context;
        this.basePath = basePath;
    }

    public ContextConfiguration configuration() {
        return new ContextConfiguration(this.citrus, this.context, this.basePath);
    }

    public void name(String name) {
        this.runner.name(name);
    }

    public void author(String author) {
        this.runner.author(author);
    }

    public void description(String description) {
        this.runner.description(description);
    }

    public void status(String status) {
        this.runner.status(TestCaseMetaInfo.Status.valueOf((String)status));
    }

    public void configuration(@DelegatesTo(value=ContextConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)new ContextConfiguration(this.citrus, this.context, this.basePath));
        callable.call();
    }

    public void variables(@DelegatesTo(value=VariablesConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)new VariablesConfiguration(this.context));
        callable.call();
    }

    public FinallySequence.Builder doFinally(@DelegatesTo(value=FinallyActionsBuilder.class) Closure<?> callable) {
        FinallyActionsBuilder builder = new FinallyActionsBuilder();
        if (callable != null) {
            callable.setResolveStrategy(1);
            callable.setDelegate((Object)builder);
            callable.call();
            this.runner.run((TestActionBuilder)builder.get());
        }
        return builder.get();
    }

    @Override
    public <T extends TestAction> T $(TestActionBuilder<T> builder) {
        return (T)this.runner.run(builder);
    }
}

