/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.endpoints;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.function.Supplier;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointBuilderConfiguration;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointBuilderHelper;

public class EndpointConfiguration
extends GroovyObjectSupport
implements Supplier<Endpoint> {
    private final String type;
    private EndpointBuilderConfiguration<?> delegate;

    public EndpointConfiguration(String type) {
        this.type = type;
    }

    private void delegateTo(EndpointBuilder<?> builder, Closure<?> callable) {
        this.delegate = new EndpointBuilderConfiguration(builder);
        callable.setResolveStrategy(1);
        callable.setDelegate(this.delegate);
        callable.call();
    }

    public Object methodMissing(String name, Object argLine) {
        if (argLine == null) {
            throw new MissingMethodException(name, EndpointConfiguration.class, null);
        }
        Object[] args = (Object[])argLine;
        EndpointBuilder<?> builder = EndpointBuilderHelper.find(this.type + "." + EndpointBuilderHelper.sanitizeEndpointBuilderName(name));
        Object closure = null;
        if (args.length > 1) {
            String endpointName = args[0].toString();
            if (builder instanceof AbstractEndpointBuilder) {
                ((AbstractEndpointBuilder)builder).name(endpointName);
            }
            closure = args[1];
        } else if (args.length == 1) {
            closure = args[0];
        }
        if (closure instanceof Closure) {
            this.delegateTo(builder, (Closure)closure);
            return null;
        }
        this.delegate = new EndpointBuilderConfiguration(builder);
        return builder;
    }

    @Override
    public Endpoint get() {
        return this.delegate.get();
    }
}

