/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.actions;

import org.citrusframework.Citrus;
import org.citrusframework.TestActionRunner;
import org.citrusframework.context.TestContext;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.groovy.dsl.actions.ActionsConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ActionsScript {
    private final String script;
    private final Citrus citrus;

    public ActionsScript(String script, Citrus citrus) {
        this.script = script;
        this.citrus = citrus;
    }

    public void execute(TestActionRunner runner, TestContext context) {
        ImportCustomizer ic = new ImportCustomizer();
        GroovyShellUtils.autoAddImports(this.script, ic);
        GroovyShellUtils.run(ic, new ActionsConfiguration(runner, context), ActionsScript.normalize(this.script), this.citrus, context);
    }

    public static String normalize(String script) {
        String normalized = GroovyShellUtils.removeComments(script);
        if (ActionsScript.isActionScript(normalized)) {
            if (normalized.startsWith("$(")) {
                return String.format("actions { %s }", normalized);
            }
            return normalized;
        }
        return String.format("actions { $(%s) }", normalized);
    }

    public static boolean isActionScript(String script) {
        if ((script.startsWith("package ") || script.startsWith("import ")) && (script.contains("actions {") || script.contains("actions{"))) {
            return true;
        }
        return script.startsWith("actions {") || script.startsWith("actions{") || script.startsWith("$actions {") || script.startsWith("$actions{") || script.startsWith("$finally {") || script.startsWith("$finally{") || script.startsWith("$(");
    }
}

