/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml.parser;

import org.citrusframework.config.xml.parser.ScriptMessageBuilderParser;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.builder.script.GroovyFileResourcePayloadBuilder;
import org.citrusframework.message.builder.script.GroovyScriptPayloadBuilder;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.builder.DefaultMessageBuilder;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GroovyScriptMessageBuilderParser
implements ScriptMessageBuilderParser {
    public DefaultMessageBuilder parse(Element messageElement) {
        Element builderElement = this.getBuilderElement(messageElement);
        DefaultMessageBuilder scriptMessageBuilder = new DefaultMessageBuilder();
        String scriptResourcePath = builderElement.getAttribute("file");
        if (StringUtils.hasText((String)scriptResourcePath)) {
            if (builderElement.hasAttribute("charset")) {
                scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyFileResourcePayloadBuilder(scriptResourcePath, builderElement.getAttribute("charset")));
            } else {
                scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyFileResourcePayloadBuilder(scriptResourcePath));
            }
        } else {
            scriptMessageBuilder.setPayloadBuilder((MessagePayloadBuilder)new GroovyScriptPayloadBuilder(DomUtils.getTextValue((Element)builderElement).trim()));
        }
        if (messageElement.hasAttribute("name")) {
            scriptMessageBuilder.setName(messageElement.getAttribute("name"));
        }
        return scriptMessageBuilder;
    }
}

