/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ftp.FtpSettings;
import org.citrusframework.ftp.model.Command;
import org.citrusframework.ftp.model.CommandResult;
import org.citrusframework.ftp.model.ConnectCommand;
import org.citrusframework.ftp.model.DeleteCommand;
import org.citrusframework.ftp.model.DeleteCommandResult;
import org.citrusframework.ftp.model.GetCommand;
import org.citrusframework.ftp.model.GetCommandResult;
import org.citrusframework.ftp.model.ListCommand;
import org.citrusframework.ftp.model.ListCommandResult;
import org.citrusframework.ftp.model.PutCommand;
import org.citrusframework.ftp.model.PutCommandResult;
import org.citrusframework.message.MessageType;
import org.citrusframework.spi.Resources;
import org.citrusframework.xml.Jaxb2Marshaller;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.StringResult;
import org.citrusframework.xml.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpMarshaller
implements Marshaller,
Unmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(FtpMarshaller.class);
    private String type = FtpSettings.getMarshallerType();
    private final ObjectMapper mapper;
    private final Jaxb2Marshaller marshaller;
    private final Class<?>[] classesToBeBound = new Class[]{Command.class, CommandResult.class, ConnectCommand.class, GetCommand.class, PutCommand.class, ListCommand.class, DeleteCommand.class, GetCommandResult.class, PutCommandResult.class, ListCommandResult.class, DeleteCommandResult.class};

    public FtpMarshaller() {
        this.mapper = new ObjectMapper();
        this.marshaller = new Jaxb2Marshaller(Resources.fromClasspath((String)"org/citrusframework/schema/citrus-ftp-message.xsd"), (Class[])this.classesToBeBound);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Object unmarshal(Source source) {
        if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException e) {
                if (source instanceof StreamSource) {
                    for (Class<?> type : this.classesToBeBound) {
                        try {
                            return this.mapper.readValue(((StreamSource)source).getReader(), type);
                        }
                        catch (JsonParseException | JsonMappingException e2) {
                        }
                        catch (IOException io) {
                            logger.warn("Failed to read ftp JSON object from source: " + io.getMessage());
                            break;
                        }
                    }
                }
                throw new CitrusRuntimeException("Failed to read ftp XML object from source", (Throwable)e);
            }
        }
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            for (Class<?> type : this.classesToBeBound) {
                try {
                    return this.mapper.readValue(((StreamSource)source).getReader(), type);
                }
                catch (JsonParseException | JsonMappingException e2) {
                }
                catch (IOException io) {
                    throw new CitrusRuntimeException("Failed to read ftp JSON object from source", (Throwable)io);
                }
            }
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException me) {
                logger.warn("Failed to read ftp XML object from source: " + me.getMessage());
                throw new CitrusRuntimeException("Failed to read ftp JSON object from source" + source);
            }
        }
        throw new CitrusRuntimeException("Unsupported ftp marshaller type: " + this.type);
    }

    public void marshal(Object graph, Result result) {
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            if (result instanceof StringResult) {
                StringWriter writer = new StringWriter();
                ((StringResult)result).setWriter((Writer)writer);
                try {
                    this.mapper.writer().writeValue((Writer)writer, graph);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to write ftp JSON object graph to result", (Throwable)e);
                }
            }
        } else if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                this.marshaller.marshal(graph, result);
            }
            catch (JAXBException e) {
                throw new CitrusRuntimeException("Failed to write ftp XML object to result", (Throwable)e);
            }
        } else {
            throw new CitrusRuntimeException("Unsupported ftp marshaller type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

