/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.ftpserver.ftplet.DataType;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ftp.client.FtpClient;
import org.citrusframework.ftp.client.SftpEndpointConfiguration;
import org.citrusframework.ftp.message.FtpMessage;
import org.citrusframework.ftp.model.CommandType;
import org.citrusframework.ftp.model.DeleteCommand;
import org.citrusframework.ftp.model.GetCommand;
import org.citrusframework.ftp.model.ListCommand;
import org.citrusframework.ftp.model.PutCommand;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpClient
extends FtpClient {
    private static final Logger logger = LoggerFactory.getLogger(SftpClient.class);
    private Session session;
    private JSch ssh;
    private ChannelSftp sftp;

    public SftpClient() {
        this(new SftpEndpointConfiguration());
    }

    protected SftpClient(SftpEndpointConfiguration endpointConfiguration) {
        super(endpointConfiguration);
    }

    @Override
    public SftpEndpointConfiguration getEndpointConfiguration() {
        return (SftpEndpointConfiguration)super.getEndpointConfiguration();
    }

    @Override
    protected FtpMessage executeCommand(CommandType ftpCommand, TestContext context) {
        if (ftpCommand.getSignal().equals(FTPCmd.MKD.getCommand())) {
            return this.createDir(ftpCommand);
        }
        if (ftpCommand.getSignal().equals(FTPCmd.LIST.getCommand())) {
            return this.listFiles(FtpMessage.list(ftpCommand.getArguments()).getPayload(ListCommand.class), context);
        }
        if (ftpCommand.getSignal().equals(FTPCmd.DELE.getCommand())) {
            return this.deleteFile(FtpMessage.delete(ftpCommand.getArguments()).getPayload(DeleteCommand.class), context);
        }
        if (ftpCommand.getSignal().equals(FTPCmd.STOR.getCommand())) {
            return this.storeFile(FtpMessage.put(ftpCommand.getArguments()).getPayload(PutCommand.class), context);
        }
        if (ftpCommand.getSignal().equals(FTPCmd.RETR.getCommand())) {
            return this.retrieveFile(FtpMessage.get(ftpCommand.getArguments()).getPayload(GetCommand.class), context);
        }
        throw new CitrusRuntimeException(String.format("Unsupported ftp command '%s'", ftpCommand.getSignal()));
    }

    protected FtpMessage createDir(CommandType ftpCommand) {
        try {
            this.sftp.mkdir(ftpCommand.getArguments());
            return FtpMessage.result(257, "Pathname created", true);
        }
        catch (SftpException e) {
            throw new CitrusRuntimeException("Failed to execute ftp command", (Throwable)e);
        }
    }

    @Override
    protected FtpMessage listFiles(ListCommand list, TestContext context) {
        String remoteFilePath = Optional.ofNullable(list.getTarget()).map(ListCommand.Target::getPath).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse("");
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            Vector entries = this.sftp.ls(remoteFilePath);
            for (ChannelSftp.LsEntry entry : entries) {
                fileNames.add(entry.getFilename());
            }
            return FtpMessage.result(150, "List files complete", fileNames);
        }
        catch (SftpException e) {
            throw new CitrusRuntimeException(String.format("Failed to list files in path '%s'", remoteFilePath), (Throwable)e);
        }
    }

    @Override
    protected FtpMessage deleteFile(DeleteCommand delete, TestContext context) {
        String remoteFilePath = context.replaceDynamicContentInString(delete.getTarget().getPath());
        try {
            if (!StringUtils.hasText((String)remoteFilePath)) {
                return null;
            }
            if (this.isDirectory(remoteFilePath)) {
                this.sftp.cd(remoteFilePath);
                if (delete.isRecursive()) {
                    Vector entries = this.sftp.ls(".");
                    List<String> excludedDirs = Arrays.asList(".", "..");
                    for (ChannelSftp.LsEntry entry : entries) {
                        if (excludedDirs.contains(entry.getFilename())) continue;
                        DeleteCommand recursiveDelete = new DeleteCommand();
                        DeleteCommand.Target target = new DeleteCommand.Target();
                        target.setPath(remoteFilePath + "/" + entry.getFilename());
                        recursiveDelete.setTarget(target);
                        recursiveDelete.setIncludeCurrent(true);
                        this.deleteFile(recursiveDelete, context);
                    }
                }
                if (delete.isIncludeCurrent()) {
                    this.sftp.cd("..");
                    this.sftp.rmdir(remoteFilePath);
                }
            } else {
                this.sftp.rm(remoteFilePath);
            }
        }
        catch (SftpException e) {
            throw new CitrusRuntimeException("Failed to delete file from FTP server", (Throwable)e);
        }
        return FtpMessage.deleteResult(250, "Delete file complete", true);
    }

    @Override
    protected boolean isDirectory(String remoteFilePath) {
        try {
            return !remoteFilePath.contains("*") && this.sftp.stat(remoteFilePath).isDir();
        }
        catch (SftpException e) {
            throw new CitrusRuntimeException("Failed to check file state", (Throwable)e);
        }
    }

    @Override
    protected FtpMessage storeFile(PutCommand command, TestContext context) {
        try {
            String localFilePath = context.replaceDynamicContentInString(command.getFile().getPath());
            String remoteFilePath = SftpClient.addFileNameToTargetPath(localFilePath, context.replaceDynamicContentInString(command.getTarget().getPath()));
            String dataType = context.replaceDynamicContentInString(Optional.ofNullable(command.getFile().getType()).orElseGet(() -> DataType.BINARY.name()));
            try (InputStream localFileInputStream = this.getLocalFileInputStream(command.getFile().getPath(), dataType, context);){
                this.sftp.put(localFileInputStream, remoteFilePath);
            }
        }
        catch (SftpException | IOException e) {
            throw new CitrusRuntimeException("Failed to put file to FTP server", e);
        }
        return FtpMessage.putResult(226, "Transfer complete", true);
    }

    @Override
    protected FtpMessage retrieveFile(GetCommand command, TestContext context) {
        try {
            String remoteFilePath = context.replaceDynamicContentInString(command.getFile().getPath());
            String localFilePath = SftpClient.addFileNameToTargetPath(remoteFilePath, context.replaceDynamicContentInString(command.getTarget().getPath()));
            try (InputStream inputStream = this.sftp.get(remoteFilePath);){
                byte[] bytes = FileUtils.copyToByteArray((InputStream)inputStream);
                Path localFilePathObj = Paths.get(localFilePath, new String[0]);
                Files.createDirectories(localFilePathObj.getParent(), new FileAttribute[0]);
                Files.write(localFilePathObj, bytes, new OpenOption[0]);
            }
            catch (SftpException e) {
                throw new CitrusRuntimeException(String.format("Failed to get file from FTP server. Remote path: %s. Local file path: %s. Error: %s", remoteFilePath, localFilePath, e.getMessage()));
            }
            if (this.getEndpointConfiguration().isAutoReadFiles()) {
                String fileContent = command.getFile().getType().equals(DataType.BINARY.name()) ? Base64.encodeBase64String((byte[])FileUtils.copyToByteArray((Resource)FileUtils.getFileResource((String)localFilePath))) : FileUtils.readToString((Resource)FileUtils.getFileResource((String)localFilePath));
                return FtpMessage.result(226, "Transfer complete", localFilePath, fileContent);
            }
            return FtpMessage.result(226, "Transfer complete", localFilePath, null);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get file from FTP server", (Throwable)e);
        }
    }

    @Override
    protected void connectAndLogin() {
        if (this.getEndpointConfiguration().isStrictHostChecking()) {
            this.setKnownHosts();
        }
        if (this.session == null || !this.session.isConnected()) {
            try {
                if (StringUtils.hasText((String)this.getEndpointConfiguration().getPrivateKeyPath())) {
                    this.ssh.addIdentity(this.getPrivateKeyPath(), this.getEndpointConfiguration().getPrivateKeyPassword());
                }
            }
            catch (JSchException e) {
                throw new CitrusRuntimeException("Cannot add private key " + this.getEndpointConfiguration().getPrivateKeyPath() + ": " + e, (Throwable)e);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Cannot open private key file " + this.getEndpointConfiguration().getPrivateKeyPath() + ": " + e, (Throwable)e);
            }
            try {
                this.session = this.ssh.getSession(this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort());
                if (StringUtils.hasText((String)this.getEndpointConfiguration().getPassword())) {
                    this.session.setUserInfo((UserInfo)new UserInfoWithPlainPassword(this.getEndpointConfiguration().getPassword()));
                    this.session.setPassword(this.getEndpointConfiguration().getPassword());
                }
                this.session.setConfig("StrictHostKeyChecking", this.getEndpointConfiguration().isStrictHostChecking() ? "yes" : "no");
                this.session.setConfig("PreferredAuthentications", this.getEndpointConfiguration().getPreferredAuthentications());
                this.getEndpointConfiguration().getSessionConfigs().entrySet().stream().peek(entry -> logger.info(String.format("Setting session configuration: %s='%s'", entry.getKey(), entry.getValue()))).forEach(entry -> this.session.setConfig((String)entry.getKey(), (String)entry.getValue()));
                this.session.connect((int)this.getEndpointConfiguration().getTimeout());
                Channel channel = this.session.openChannel("sftp");
                channel.connect((int)this.getEndpointConfiguration().getTimeout());
                this.sftp = (ChannelSftp)channel;
                logger.info("Opened secure connection to FTP server");
            }
            catch (JSchException e) {
                throw new CitrusRuntimeException(String.format("Failed to login to FTP server using credentials: %s:%s", this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getPassword()), (Throwable)e);
            }
        }
    }

    private void setKnownHosts() {
        if (this.getEndpointConfiguration().getKnownHosts() == null) {
            throw new CitrusRuntimeException("Strict host checking is enabled but no knownHosts given");
        }
        try {
            this.ssh.setKnownHosts(FileUtils.getFileResource((String)this.getEndpointConfiguration().getKnownHosts()).getInputStream());
        }
        catch (JSchException e) {
            throw new CitrusRuntimeException("Cannot add known hosts from " + this.getEndpointConfiguration().getKnownHosts() + ": " + e, (Throwable)e);
        }
    }

    protected String getPrivateKeyPath() throws IOException {
        if (!StringUtils.hasText((String)this.getEndpointConfiguration().getPrivateKeyPath())) {
            return null;
        }
        if (this.getEndpointConfiguration().getPrivateKeyPath().startsWith("classpath:")) {
            File priv = File.createTempFile("citrus-sftp", "priv");
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getEndpointConfiguration().getPrivateKeyPath().substring("classpath:".length()));
                 FileOutputStream fos = new FileOutputStream(priv);){
                if (is == null) {
                    throw new CitrusRuntimeException("No private key found at " + this.getEndpointConfiguration().getPrivateKeyPath());
                }
                fos.write(is.readAllBytes());
                fos.flush();
            }
            return priv.getAbsolutePath();
        }
        return this.getEndpointConfiguration().getPrivateKeyPath();
    }

    @Override
    public void initialize() {
        if (this.ssh == null) {
            this.ssh = new JSch();
        }
    }

    @Override
    public void destroy() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            logger.info("Closed connection to FTP server");
        }
        this.sftp.disconnect();
    }

    public JSch getSsh() {
        return this.ssh;
    }

    public void setSsh(JSch ssh) {
        this.ssh = ssh;
    }

    private static class UserInfoWithPlainPassword
    implements UserInfo {
        private String password;

        public UserInfoWithPlainPassword(String pPassword) {
            this.password = pPassword;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassword(String message) {
            return false;
        }

        public boolean promptPassphrase(String message) {
            return false;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
        }
    }
}

