/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.server;

import java.util.Map;
import org.citrusframework.ftp.client.SftpEndpointConfiguration;
import org.citrusframework.ftp.server.SftpServer;
import org.citrusframework.server.AbstractServerBuilder;

public class SftpServerBuilder
extends AbstractServerBuilder<SftpServer, SftpServerBuilder> {
    private final SftpServer endpoint = new SftpServer();

    protected SftpServer getEndpoint() {
        return this.endpoint;
    }

    public SftpServerBuilder port(int port) {
        this.endpoint.setPort(port);
        return this;
    }

    public SftpServerBuilder autoConnect(boolean autoConnect) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setAutoConnect(autoConnect);
        return this;
    }

    public SftpServerBuilder autoLogin(boolean autoLogin) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setAutoLogin(autoLogin);
        return this;
    }

    public SftpServerBuilder user(String user) {
        this.endpoint.setUser(user);
        return this;
    }

    public SftpServerBuilder password(String password) {
        this.endpoint.setPassword(password);
        return this;
    }

    public SftpServerBuilder hostKeyPath(String hostKeyPath) {
        this.endpoint.setHostKeyPath(hostKeyPath);
        return this;
    }

    public SftpServerBuilder userHomePath(String userHomePath) {
        this.endpoint.setUserHomePath(userHomePath);
        return this;
    }

    public SftpServerBuilder allowedKeyPath(String allowedKeyPath) {
        this.endpoint.setAllowedKeyPath(allowedKeyPath);
        return this;
    }

    public SftpServerBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval((long)pollingInterval);
        return this;
    }

    public SftpServerBuilder strictHostChecking(boolean strictHostChecking) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setStrictHostChecking(strictHostChecking);
        return this;
    }

    public SftpServerBuilder knownHosts(String knownHosts) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setKnownHosts(knownHosts);
        return this;
    }

    public SftpServerBuilder privateKeyPath(String privateKeyPath) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setPrivateKeyPath(privateKeyPath);
        return this;
    }

    public SftpServerBuilder privateKeyPassword(String privateKeyPassword) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setPrivateKeyPassword(privateKeyPassword);
        return this;
    }

    public SftpServerBuilder preferredAuthentications(String preferredAuthentications) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setPreferredAuthentications(preferredAuthentications);
        return this;
    }

    public SftpServerBuilder sessionConfigs(Map<String, String> sessionConfigs) {
        ((SftpEndpointConfiguration)this.endpoint.getEndpointConfiguration()).setSessionConfigs(sessionConfigs);
        return this;
    }
}

