/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.server;

import java.util.HashMap;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ftp.client.FtpEndpointConfiguration;
import org.citrusframework.ftp.server.FtpServerFtpLet;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.spi.Resource;

public class FtpServer
extends AbstractServer {
    private FtpServerFactory serverFactory;
    private ListenerFactory listenerFactory;
    private UserManager userManager;
    private org.apache.ftpserver.FtpServer ftpServer;
    private final FtpEndpointConfiguration endpointConfiguration;
    private Resource userManagerProperties;
    private static final Object serverLock = new Object();

    public FtpServer() {
        this(new FtpEndpointConfiguration());
    }

    public FtpServer(FtpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Object object = serverLock;
        synchronized (object) {
            if (this.ftpServer == null) {
                this.listenerFactory.setPort(this.endpointConfiguration.getPort());
                this.serverFactory.addListener("default", this.listenerFactory.createListener());
                if (this.userManager != null) {
                    this.serverFactory.setUserManager(this.userManager);
                } else if (this.userManagerProperties != null) {
                    PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
                    userManagerFactory.setFile(this.userManagerProperties.getFile());
                    this.serverFactory.setUserManager(userManagerFactory.createUserManager());
                }
                NativeFileSystemFactory fileSystemFactory = new NativeFileSystemFactory();
                fileSystemFactory.setCreateHome(true);
                this.serverFactory.setFileSystem((FileSystemFactory)fileSystemFactory);
                HashMap<String, FtpServerFtpLet> ftpLets = new HashMap<String, FtpServerFtpLet>();
                ftpLets.put("citrusFtpLet", new FtpServerFtpLet(this.getEndpointConfiguration(), this.getEndpointAdapter()));
                this.serverFactory.setFtplets(ftpLets);
                this.ftpServer = this.serverFactory.createServer();
            }
            try {
                this.ftpServer.start();
            }
            catch (FtpException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.ftpServer != null) {
            try {
                Object object = serverLock;
                synchronized (object) {
                    this.ftpServer.stop();
                }
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public FtpEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void initialize() {
        if (this.ftpServer == null) {
            if (this.serverFactory == null) {
                this.serverFactory = new FtpServerFactory();
            }
            if (this.listenerFactory == null) {
                this.listenerFactory = new ListenerFactory();
            }
        }
        super.initialize();
    }

    public void setFtpServer(org.apache.ftpserver.FtpServer ftpServer) {
        this.ftpServer = ftpServer;
    }

    public org.apache.ftpserver.FtpServer getFtpServer() {
        return this.ftpServer;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManagerProperties(Resource userManagerProperties) {
        this.userManagerProperties = userManagerProperties;
    }

    public Resource getUserManagerProperties() {
        return this.userManagerProperties;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }
}

