/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.ftp.config.annotation.SftpServerConfig;
import org.citrusframework.ftp.server.SftpServer;
import org.citrusframework.ftp.server.SftpServerBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class SftpServerConfigParser
implements AnnotationConfigParser<SftpServerConfig, SftpServer> {
    public SftpServer parse(SftpServerConfig annotation, ReferenceResolver referenceResolver) {
        SftpServerBuilder builder = new SftpServerBuilder();
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.user())) {
            builder.user(annotation.user());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.hostKeyPath())) {
            builder.hostKeyPath(annotation.hostKeyPath());
        }
        if (StringUtils.hasText((String)annotation.userHomePath())) {
            builder.userHomePath(annotation.userHomePath());
        }
        if (StringUtils.hasText((String)annotation.allowedKeyPath())) {
            builder.allowedKeyPath(annotation.allowedKeyPath());
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)referenceResolver.resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.autoStart(annotation.autoStart());
        builder.autoConnect(annotation.autoConnect());
        builder.autoLogin(annotation.autoLogin());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (SftpServer)builder.initialize().build();
    }
}

