/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ValidationMatcher;

public class DatePatternValidationMatcher
implements ValidationMatcher {
    public void validate(String fieldName, String value, List<String> controlParameters, TestContext context) throws ValidationException {
        SimpleDateFormat dateFormat;
        String control = controlParameters.get(0);
        try {
            dateFormat = new SimpleDateFormat(control);
        }
        catch (PatternSyntaxException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "' . Found invalid date format", (Throwable)e);
        }
        try {
            dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received invalid date format for value '" + value + "', expected date format is '" + control + "'", (Throwable)e);
        }
    }
}

