/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.ValueMatcher;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public abstract class ValidationUtils {
    private static final Map<String, ValueMatcher> DEFAULT_VALUE_MATCHERS = ValueMatcher.lookup();

    private ValidationUtils() {
    }

    public static void validateValues(Object actualValue, Object expectedValue, String pathExpression, TestContext context) throws ValidationException {
        block30: {
            try {
                if (actualValue != null) {
                    if (expectedValue == null) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", null, actualValue));
                    }
                    Optional<ValueMatcher> matcher = ValidationUtils.getValueMatcher(expectedValue, context);
                    if (matcher.isPresent()) {
                        if (!matcher.get().validate(actualValue, expectedValue, context)) {
                            throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, actualValue));
                        }
                        return;
                    }
                    if (!(expectedValue instanceof String)) {
                        Object converted = context.getTypeConverter().convertIfNecessary(actualValue, expectedValue.getClass());
                        if (converted == null) {
                            throw new CitrusRuntimeException(String.format("Failed to convert value '%s' to required type '%s'", actualValue, expectedValue.getClass()));
                        }
                        if (converted instanceof List) {
                            if (!converted.toString().equals(expectedValue.toString())) {
                                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue.toString(), converted.toString()));
                            }
                        } else if (converted instanceof String[]) {
                            String expectedDelimitedString;
                            String convertedDelimitedString = String.join((CharSequence)",", (String[])converted);
                            if (!convertedDelimitedString.equals(expectedDelimitedString = String.join((CharSequence)",", (String[])expectedValue))) {
                                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedDelimitedString, convertedDelimitedString));
                            }
                        } else if (converted instanceof byte[]) {
                            String expectedBase64;
                            String convertedBase64 = Base64.encodeBase64String((byte[])((byte[])converted));
                            if (!convertedBase64.equals(expectedBase64 = Base64.encodeBase64String((byte[])((byte[])expectedValue)))) {
                                throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedBase64, convertedBase64));
                            }
                        } else if (!converted.equals(expectedValue)) {
                            throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, converted));
                        }
                    } else {
                        String actualValueString;
                        String expectedValueString = expectedValue.toString();
                        if (List.class.isAssignableFrom(actualValue.getClass())) {
                            actualValueString = String.join((CharSequence)",", ((List)actualValue).stream().map(Object::toString).toList());
                            expectedValueString = expectedValueString.replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                        } else {
                            actualValueString = actualValue.toString();
                        }
                        if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValueString)) {
                            ValidationMatcherUtils.resolveValidationMatcher((String)pathExpression, (String)actualValueString, (String)expectedValueString, (TestContext)context);
                        } else if (!actualValueString.equals(expectedValueString)) {
                            throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, actualValueString));
                        }
                    }
                    break block30;
                }
                if (expectedValue == null) break block30;
                Optional<ValueMatcher> matcher = ValidationUtils.getValueMatcher(expectedValue, context);
                if (matcher.isPresent()) {
                    if (!matcher.get().validate(actualValue, expectedValue, context)) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, null));
                    }
                    break block30;
                }
                if (expectedValue instanceof String) {
                    String expectedValueString = expectedValue.toString();
                    if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValueString)) {
                        ValidationMatcherUtils.resolveValidationMatcher((String)pathExpression, null, (String)expectedValueString, (TestContext)context);
                    } else if (!expectedValueString.isBlank()) {
                        throw new ValidationException(ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, null));
                    }
                    break block30;
                }
                throw new ValidationException("Validation failed: " + ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, null));
            }
            catch (AssertionError | IllegalArgumentException e) {
                throw new ValidationException("Validation failed:", (Throwable)e);
            }
        }
    }

    private static Optional<ValueMatcher> getValueMatcher(Object expectedValue, TestContext context) {
        HashMap<String, ValueMatcher> allMatchers = new HashMap<String, ValueMatcher>(DEFAULT_VALUE_MATCHERS);
        allMatchers.putAll(context.getReferenceResolver().resolveAll(ValueMatcher.class));
        return allMatchers.values().stream().filter(matcher -> matcher.supports(expectedValue.getClass())).findFirst();
    }

    public static String buildValueMismatchErrorMessage(String baseMessage, Object controlValue, Object actualValue) {
        return baseMessage + ", expected '" + controlValue + "' but was '" + actualValue + "'";
    }

    public static String buildValueToBeInCollectionErrorMessage(String baseMessage, Object controlValue, Collection<?> actualValues) {
        return baseMessage + ", expected '" + controlValue + "' to be in '" + actualValues + "'";
    }
}

