/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.IOException;
import java.util.Properties;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.report.AbstractOutputFileReporter;
import org.citrusframework.report.SummaryReporterSettings;
import org.citrusframework.report.TestResults;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.PropertyUtils;

public class SummaryReporter
extends AbstractOutputFileReporter {
    private boolean enabled = SummaryReporterSettings.isReportEnabled();
    private String reportFileName = SummaryReporterSettings.getReportFile();
    private String reportTemplate = SummaryReporterSettings.getReportTemplate();

    @Override
    protected String getReportContent(TestResults testResults) {
        try {
            Properties reportProps = new Properties();
            reportProps.put("test.cnt", Integer.toString(testResults.getSize()));
            reportProps.put("skipped.test.cnt", Integer.toString(testResults.getSkipped()));
            reportProps.put("skipped.test.pct", testResults.getSkippedPercentage());
            reportProps.put("failed.test.cnt", Integer.toString(testResults.getFailed()));
            reportProps.put("failed.test.pct", testResults.getFailedPercentage());
            reportProps.put("success.test.cnt", Integer.toString(testResults.getSuccess()));
            reportProps.put("success.test.pct", testResults.getSuccessPercentage());
            return PropertyUtils.replacePropertiesInString(FileUtils.readToString(FileUtils.getFileResource(this.reportTemplate)), reportProps);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to generate summary test report", (Throwable)e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected boolean isEnabled() {
        return this.enabled;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public String getReportFileName() {
        return this.reportFileName;
    }
}

