/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.citrusframework.CitrusVersion;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.TestResult;
import org.citrusframework.common.Described;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.report.AbstractTestReporter;
import org.citrusframework.report.MessageListener;
import org.citrusframework.report.TestActionListener;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestResults;
import org.citrusframework.report.TestSuiteListener;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public class LoggingReporter
extends AbstractTestReporter
implements MessageListener,
TestSuiteListener,
TestListener,
TestActionListener {
    private static Logger logger = LoggerFactory.getLogger(LoggingReporter.class);
    private static Logger inboundMessageLogger;
    private static final Logger enabledInboundMessageLogger;
    private static Logger outboundMessageLogger;
    private static final Logger enabledOutboundMessageLogger;
    private static final Logger enabledLog;
    private static final Logger noOpLogger;
    private static boolean isInitialized;

    private static void initialized() {
        isInitialized = true;
    }

    private static String formatDurationString(TestCase test) {
        return Objects.nonNull(test.getTestResult()) && Objects.nonNull(test.getTestResult().getDuration()) ? " (" + test.getTestResult().getDuration().toString() + ") " : "";
    }

    @Override
    public void generate(TestResults testResults) {
        this.newLine();
        this.info("CITRUS TEST RESULTS");
        this.newLine();
        testResults.doWithResults(testResult -> {
            this.info(this.toFormattedTestResult(testResult));
            if (testResult.isFailed()) {
                this.info(Optional.ofNullable(testResult.getCause()).filter(cause -> StringUtils.hasText(cause.getMessage())).map(ExceptionUtils::getRootCause).map(cause -> "\tCaused by: " + cause.getClass().getSimpleName() + ": " + cause.getMessage()).orElse("\tCaused by: " + Optional.ofNullable(testResult.getErrorMessage()).orElse("Unknown error")));
            }
        });
        this.newLine();
        this.info(String.format("TOTAL:\t\t%s", testResults.getFailed() + testResults.getSuccess()));
        this.info(String.format("SUCCESS:\t%s (%s%%)", testResults.getSuccess(), testResults.getSuccessPercentageFormatted()));
        this.info(String.format("FAILED:\t\t%s (%s%%)", testResults.getFailed(), testResults.getFailedPercentageFormatted()));
        this.debug(String.format("SKIPPED:\t%s (%s%%)", testResults.getSkipped(), testResults.getSkippedPercentageFormatted()));
        this.info(String.format("PERFORMANCE:\t%s ms", testResults.getTotalDuration().toMillis()));
        this.newLine();
        this.separator();
    }

    private String toFormattedTestResult(TestResult testResult) {
        return String.format("%s (%6d ms) %s", testResult.getResult(), Optional.ofNullable(testResult.getDuration()).orElse(Duration.ZERO).toMillis(), testResult.getTestName());
    }

    public void onTestFailure(TestCase testCase, Throwable cause) {
        this.newLine();
        String duration = LoggingReporter.formatDurationString(testCase);
        this.error("TEST FAILED " + testCase.getName() + " <" + testCase.getPackageName() + ">" + duration + " Nested exception is: ", cause);
        this.separator();
        this.newLine();
    }

    public void onTestSkipped(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("SKIPPING TEST: " + test.getName());
            this.newLine();
        }
    }

    public void onTestStart(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("STARTING TEST " + test.getName() + " <" + test.getPackageName() + ">");
            this.newLine();
        }
    }

    public void onTestFinish(TestCase test) {
    }

    public void onTestSuccess(TestCase test) {
        this.newLine();
        String duration = LoggingReporter.formatDurationString(test);
        this.info("TEST SUCCESS " + test.getName() + " (" + test.getPackageName() + ")" + duration);
        this.separator();
        this.newLine();
    }

    public void onFinish() {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("AFTER TEST SUITE");
            this.newLine();
        }
    }

    public void onStart() {
        if (!isInitialized) {
            this.printBanner();
            LoggingReporter.initialized();
        }
        this.separator();
        if (this.isDebugEnabled()) {
            this.debug("BEFORE TEST SUITE");
            this.newLine();
        }
    }

    private void printBanner() {
        this.info("       .__  __                       ");
        this.info("  ____ |__|/  |________ __ __  ______");
        this.info("_/ ___\\|  \\   __\\_  __ \\  |  \\/  ___/");
        this.info("\\  \\___|  ||  |  |  | \\/  |  /\\___ \\ ");
        this.info(" \\___  >__||__|  |__|  |____//____  >");
        this.info("     \\/                           \\/");
        this.newLine();
        this.info("C I T R U S  T E S T S  " + CitrusVersion.version());
        this.newLine();
    }

    public void onFinishFailure(Throwable cause) {
        this.newLine();
        this.error("AFTER TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onFinishSuccess() {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.debug("AFTER TEST SUITE: SUCCESS");
            this.separator();
            this.newLine();
        }
    }

    public void onStartFailure(Throwable cause) {
        this.newLine();
        this.error("BEFORE TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onStartSuccess() {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.debug("BEFORE TEST SUITE: SUCCESS");
            this.separator();
            this.newLine();
        }
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            Described described;
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getExecutedActions().size() + 1) + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            }
            if (testAction instanceof TestActionContainer) {
                TestActionContainer container = (TestActionContainer)testAction;
                this.debug("TEST ACTION CONTAINER with " + container.getActionCount() + " embedded actions");
            }
            if (testAction instanceof Described && StringUtils.hasText((described = (Described)testAction).getDescription())) {
                this.debug("");
                this.debug(described.getDescription());
                this.debug("");
            }
        }
    }

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            String duration = LoggingReporter.formatDurationString(testCase);
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getExecutedActions().size() + 1) + " SUCCESS" + duration);
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + " SUCCESS" + duration);
            }
        }
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("SKIPPING TEST STEP " + (testCase.getExecutedActions().size() + 1));
            } else {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount());
            }
            this.debug("TEST ACTION " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()) + " SKIPPED");
        }
    }

    public void onInboundMessage(Message message, TestContext context) {
        if (outboundMessageLogger.isDebugEnabled()) {
            inboundMessageLogger.debug(message.print(context));
        }
    }

    public void onOutboundMessage(Message message, TestContext context) {
        if (outboundMessageLogger.isDebugEnabled()) {
            outboundMessageLogger.debug(message.print(context));
        }
    }

    protected void separator() {
        this.info("------------------------------------------------------------------------");
    }

    protected void newLine() {
        this.info("");
    }

    protected void info(String line) {
        logger.info(line);
    }

    protected void error(String line) {
        logger.error(line);
    }

    protected void error(String line, Throwable cause) {
        logger.error(line, cause);
    }

    protected void debug(String line) {
        if (this.isDebugEnabled()) {
            logger.debug(line);
        }
    }

    protected boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            logger = enabledLog;
            inboundMessageLogger = enabledInboundMessageLogger;
            outboundMessageLogger = enabledOutboundMessageLogger;
        } else {
            logger = noOpLogger;
            inboundMessageLogger = noOpLogger;
            outboundMessageLogger = noOpLogger;
        }
    }

    protected boolean isEnabled() {
        return logger != noOpLogger;
    }

    static {
        enabledInboundMessageLogger = inboundMessageLogger = LoggerFactory.getLogger((String)"Logger.Message_IN");
        enabledOutboundMessageLogger = outboundMessageLogger = LoggerFactory.getLogger((String)"Logger.Message_OUT");
        enabledLog = logger;
        noOpLogger = new NOPLoggerFactory().getLogger(LoggingReporter.class.getName());
        isInitialized = false;
    }
}

