/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import java.util.Random;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;

public class RandomEnumValueFunction
implements Function {
    private Random random = new Random(System.currentTimeMillis());
    private List<String> values = null;

    public String execute(List<String> params, TestContext context) {
        if (this.values == null) {
            return this.randomValue(params);
        }
        if (!params.isEmpty()) {
            throw new InvalidFunctionUsageException("The enumeration values have already been set");
        }
        return this.randomValue(this.values);
    }

    protected String randomValue(List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new InvalidFunctionUsageException("No values to choose from");
        }
        int idx = this.random.nextInt(values.size());
        return values.get(idx);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

