/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.citrusframework.AbstractIteratingContainerBuilder;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.container.IteratingConditionExpression;
import org.citrusframework.context.TestContext;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.BooleanExpressionParser;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public abstract class AbstractIteratingActionContainer
extends AbstractActionContainer {
    protected final String condition;
    protected final IteratingConditionExpression conditionExpression;
    protected int index;
    protected final String indexName;
    protected final int start;
    private final Duration timeout;

    public AbstractIteratingActionContainer(String name, AbstractIteratingContainerBuilder<?, ?> builder) {
        super(name, (AbstractTestContainerBuilder<?, ?>)builder);
        this.condition = builder.getCondition();
        this.conditionExpression = builder.getConditionExpression();
        this.index = builder.getIndex();
        this.indexName = builder.getIndexName();
        this.start = builder.getStart();
        this.timeout = builder.getTimeout();
    }

    @Override
    public final void doExecute(TestContext context) {
        this.index = this.start;
        if (Objects.nonNull(this.timeout) && this.timeout.toMillis() > 0L) {
            this.executeIterationWithTimeout(context);
        } else {
            this.executeIteration(context);
        }
    }

    private void executeIterationWithTimeout(TestContext context) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(() -> this.executeIteration(context));
            future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CitrusRuntimeException("Iteration reached timeout!", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public String getCondition() {
        return this.condition;
    }

    public IteratingConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getStart() {
        return this.start;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    protected abstract void executeIteration(TestContext var1);

    protected void executeActions(TestContext context) {
        context.setVariable(this.indexName, (Object)String.valueOf(this.index));
        for (TestActionBuilder actionBuilder : this.actions) {
            this.executeAction(actionBuilder.build(), context);
        }
    }

    protected boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(this.index, context);
        }
        String conditionString = this.condition;
        TestContext temp = TestContextFactory.copyOf(context);
        temp.setVariable(this.indexName, (Object)String.valueOf(this.index));
        conditionString = temp.replaceDynamicContentInString(conditionString);
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)conditionString)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)"iteratingCondition", (String)String.valueOf(this.index), (String)conditionString, (TestContext)context);
                return true;
            }
            catch (AssertionError | ValidationException e) {
                return false;
            }
        }
        if (conditionString.contains(this.indexName)) {
            conditionString = conditionString.replaceAll(this.indexName, String.valueOf(this.index));
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }
}

