/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ValidationMatcher;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRangeValidationMatcher
implements ValidationMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(DateRangeValidationMatcher.class);
    private static final String FALLBACK_DATE_PATTERN = "yyyy-MM-dd";

    public void validate(String fieldName, String value, List<String> params, TestContext context) throws ValidationException {
        LOG.debug(String.format("Validating date range for date '%s' using control data: %s", value, ValidationMatcherUtils.getParameterListAsString(params)));
        try {
            Calendar dateToValidate;
            Calendar dateTo;
            Calendar dateFrom;
            String dateFromParam = params.get(0);
            String dateToParam = params.get(1);
            String datePatternParam = FALLBACK_DATE_PATTERN;
            if (params.size() == 3) {
                datePatternParam = params.get(2);
            }
            if (!this.checkInRange(dateFrom = this.toCalender(dateFromParam, datePatternParam), dateTo = this.toCalender(dateToParam, datePatternParam), dateToValidate = this.toCalender(value, datePatternParam))) {
                String validationErr = String.format("%s failed for field '%s'. Date '%s' not in range: %s - %s", this.getClass().getSimpleName(), fieldName, value, dateFromParam, dateToParam);
                throw new ValidationException(validationErr);
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw e;
            }
            String validationErr = String.format("%s failed for field '%s'", this.getClass().getSimpleName(), fieldName);
            throw new ValidationException(validationErr, (Throwable)e);
        }
    }

    protected Calendar toCalender(String date, String datePattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(dateFormat.parse(date));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException(String.format("Error parsing date '%s' using pattern '%s'", date, datePattern), (Throwable)e);
        }
        return cal;
    }

    private boolean checkInRange(Calendar dateFrom, Calendar dateTo, Calendar dateToCheck) {
        return this.checkGreaterOrEqualTo(dateFrom, dateToCheck) && this.checkGreaterOrEqualTo(dateToCheck, dateTo);
    }

    private boolean checkGreaterOrEqualTo(Calendar referenceDate, Calendar dateToCheck) {
        return referenceDate.compareTo(dateToCheck) <= 0;
    }
}

