/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.builder.WithExpressions;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.springframework.util.CollectionUtils;

public class DelegatingPathExpressionProcessor
implements MessageProcessor {
    private final Map<String, Object> pathExpressions;

    public DelegatingPathExpressionProcessor() {
        this(new Builder());
    }

    public DelegatingPathExpressionProcessor(Builder builder) {
        this.pathExpressions = builder.expressions;
    }

    public void process(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.pathExpressions)) {
            return;
        }
        LinkedHashMap<String, Object> jsonPathExpressions = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> xpathExpressions = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> pathExpression : this.pathExpressions.entrySet()) {
            String path = context.replaceDynamicContentInString(pathExpression.getKey());
            Object variable = pathExpression.getValue();
            if (JsonPathMessageValidationContext.isJsonPathExpression(path)) {
                jsonPathExpressions.put(path, variable);
                continue;
            }
            xpathExpressions.put(path, variable);
        }
        if (!jsonPathExpressions.isEmpty()) {
            MessageProcessor.Builder<?, ?> jsonPathProcessor = this.lookupMessageProcessor("jsonPath", context);
            if (jsonPathProcessor instanceof WithExpressions) {
                ((WithExpressions)jsonPathProcessor).expressions(jsonPathExpressions);
            }
            jsonPathProcessor.build().process(message, context);
        }
        if (!xpathExpressions.isEmpty()) {
            MessageProcessor.Builder<?, ?> xpathProcessor = this.lookupMessageProcessor("xpath", context);
            if (xpathProcessor instanceof WithExpressions) {
                ((WithExpressions)xpathProcessor).expressions(xpathExpressions);
            }
            xpathProcessor.build().process(message, context);
        }
    }

    private MessageProcessor.Builder<?, ?> lookupMessageProcessor(String type, TestContext context) {
        return MessageProcessor.lookup((String)type).orElseGet(() -> {
            if (context.getReferenceResolver().isResolvable(type, MessageProcessor.Builder.class)) {
                return (MessageProcessor.Builder)context.getReferenceResolver().resolve(type, MessageProcessor.Builder.class);
            }
            if (context.getReferenceResolver().isResolvable(type + "MessageProcessorBuilder", MessageProcessor.Builder.class)) {
                return (MessageProcessor.Builder)context.getReferenceResolver().resolve(type + "MessageProcessorBuilder", MessageProcessor.Builder.class);
            }
            throw new CitrusRuntimeException(String.format("Missing proper message processor implementation of type '%s' - consider adding proper module to the project", type));
        });
    }

    public Map<String, Object> getPathExpressions() {
        return this.pathExpressions;
    }

    public static final class Builder
    implements MessageProcessor.Builder<DelegatingPathExpressionProcessor, Builder>,
    WithExpressions<Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder xpath() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public DelegatingPathExpressionProcessor build() {
            return new DelegatingPathExpressionProcessor(this);
        }
    }
}

