/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.springframework.util.StringUtils;

public class SubstringFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.size() < 2) {
            throw new InvalidFunctionUsageException("Insufficient function parameters - parameter usage: (targetString, beginIndex, [endIndex])");
        }
        String targetString = parameterList.get(0);
        String beginIndex = parameterList.get(1);
        String endIndex = null;
        if (!StringUtils.hasText((String)beginIndex)) {
            throw new InvalidFunctionUsageException("Invalid beginIndex - please check function parameters");
        }
        if (parameterList.size() > 2) {
            endIndex = parameterList.get(2);
        }
        targetString = StringUtils.hasText(endIndex) ? targetString.substring(Integer.valueOf(beginIndex), Integer.valueOf(endIndex)) : targetString.substring(Integer.valueOf(beginIndex));
        return targetString;
    }
}

