/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractSuiteContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractSuiteActionContainer;
import org.citrusframework.container.BeforeSuite;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceBeforeSuite
extends AbstractSuiteActionContainer
implements BeforeSuite {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceBeforeSuite.class);

    @Override
    public void doExecute(TestContext context) {
        LOG.info("Entering before suite block");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this.actions.size() + " actions before suite");
            LOG.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            try {
                action.execute(context);
            }
            catch (Exception e) {
                LOG.error("Task failed " + action.getName() + "Nested exception is: ", (Throwable)e);
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public static class Builder
    extends AbstractSuiteContainerBuilder<SequenceBeforeSuite, Builder> {
        public static Builder beforeSuite() {
            return new Builder();
        }

        @Override
        public SequenceBeforeSuite doBuild() {
            return new SequenceBeforeSuite();
        }
    }
}

