/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.TestAction;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageDirection;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessagePayloadUtils;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageSelectorBuilder;
import org.citrusframework.message.WithPayloadBuilder;
import org.citrusframework.message.builder.DefaultPayloadBuilder;
import org.citrusframework.message.builder.MessageBuilderSupport;
import org.citrusframework.message.builder.ReceiveMessageBuilderSupport;
import org.citrusframework.messaging.Consumer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.validation.DefaultMessageHeaderValidator;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.ValidationContextAdapter;
import org.citrusframework.validation.ValidationProcessor;
import org.citrusframework.validation.builder.StaticMessageBuilder;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.json.JsonMessageValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.script.ScriptValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.validation.xml.XpathMessageValidationContext;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ReceiveMessageAction
extends AbstractTestAction {
    private final Map<String, Object> messageSelectorMap;
    private final String messageSelector;
    private final Endpoint endpoint;
    private final String endpointUri;
    private final long receiveTimeout;
    private final MessageBuilder messageBuilder;
    private final List<MessageValidator<? extends ValidationContext>> validators;
    private final DataDictionary<?> dataDictionary;
    private final ValidationProcessor validationProcessor;
    private final List<ValidationContext> validationContexts;
    private final List<VariableExtractor> variableExtractors;
    private final List<MessageProcessor> messageProcessors;
    private final List<MessageProcessor> controlMessageProcessors;
    private final String messageType;
    private static final Logger LOG = LoggerFactory.getLogger(ReceiveMessageAction.class);

    public ReceiveMessageAction(ReceiveMessageActionBuilder<?, ?, ?> builder) {
        super("receive", builder);
        this.endpoint = builder.getEndpoint();
        this.endpointUri = builder.getEndpointUri();
        this.receiveTimeout = builder.receiveTimeout;
        this.messageSelector = builder.messageSelector;
        this.messageSelectorMap = builder.messageSelectorMap;
        this.validators = builder.validators;
        this.validationProcessor = builder.validationProcessor;
        this.validationContexts = builder.getValidationContexts();
        this.variableExtractors = builder.getVariableExtractors();
        this.messageProcessors = builder.getMessageProcessors();
        this.messageBuilder = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageBuilder();
        this.dataDictionary = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getDataDictionary();
        this.controlMessageProcessors = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getControlMessageProcessors();
        this.messageType = ((ReceiveMessageBuilderSupport)builder.getMessageBuilderSupport()).getMessageType();
    }

    @Override
    public void doExecute(TestContext context) {
        String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
        Message receivedMessage = StringUtils.hasText((String)selector) ? this.receiveSelected(context, selector) : this.receive(context);
        if (receivedMessage == null) {
            throw new CitrusRuntimeException("Failed to receive message - message is not available");
        }
        this.validateMessage(receivedMessage, context);
    }

    private Message receive(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        return this.receiveTimeout > 0L ? messageEndpoint.createConsumer().receive(context, this.receiveTimeout) : messageEndpoint.createConsumer().receive(context, messageEndpoint.getEndpointConfiguration().getTimeout());
    }

    private Message receiveSelected(TestContext context, String selectorString) {
        Endpoint messageEndpoint;
        Consumer consumer;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting message selector: '" + selectorString + "'");
        }
        if ((consumer = (messageEndpoint = this.getOrCreateEndpoint(context)).createConsumer()) instanceof SelectiveConsumer) {
            if (this.receiveTimeout > 0L) {
                return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, this.receiveTimeout);
            }
            return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, messageEndpoint.getEndpointConfiguration().getTimeout());
        }
        LOG.warn(String.format("Unable to receive selective with consumer implementation: '%s'", consumer.getClass()));
        return this.receive(context);
    }

    protected void validateMessage(Message message, TestContext context) {
        this.messageProcessors.forEach(processor -> processor.process(message, context));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received message:\n" + message.print(context));
        }
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(message, context);
        }
        if (StringUtils.hasText((String)message.getName())) {
            context.getMessageStore().storeMessage(message.getName(), message);
        } else {
            context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName((TestAction)this, this.getOrCreateEndpoint(context)), message);
        }
        if (this.validationProcessor != null) {
            this.validationProcessor.validate(message, context);
        } else {
            Message controlMessage = this.createControlMessage(context, this.messageType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Control message:\n" + controlMessage.print(context));
            }
            if (StringUtils.hasText((String)controlMessage.getName())) {
                context.getMessageStore().storeMessage(controlMessage.getName(), message);
            } else {
                context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName((TestAction)this, this.getOrCreateEndpoint(context)), message);
            }
            if (!CollectionUtils.isEmpty(this.validators)) {
                MessageValidator messageValidator;
                for (MessageValidator<? extends ValidationContext> messageValidator2 : this.validators) {
                    messageValidator2.validateMessage(message, controlMessage, context, this.validationContexts);
                }
                if (this.validators.parallelStream().map(Object::getClass).noneMatch(DefaultMessageHeaderValidator.class::isAssignableFrom) && (messageValidator = context.getMessageValidatorRegistry().getDefaultMessageHeaderValidator()) != null) {
                    messageValidator.validateMessage(message, controlMessage, context, this.validationContexts);
                }
            } else {
                List list = context.getMessageValidatorRegistry().findMessageValidators(this.messageType, message);
                if (list.isEmpty()) {
                    if (controlMessage.getPayload() instanceof String && StringUtils.hasText((String)((String)controlMessage.getPayload(String.class)))) {
                        throw new CitrusRuntimeException(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                    }
                    if (this.validationContexts.stream().anyMatch(item -> JsonPathMessageValidationContext.class.isAssignableFrom(item.getClass()) || XpathMessageValidationContext.class.isAssignableFrom(item.getClass()) || ScriptValidationContext.class.isAssignableFrom(item.getClass()))) {
                        throw new CitrusRuntimeException(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                    }
                    LOG.warn(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                }
                for (MessageValidator messageValidator : list) {
                    messageValidator.validateMessage(message, controlMessage, context, this.validationContexts);
                }
            }
        }
    }

    protected Message createControlMessage(TestContext context, String messageType) {
        Message message = this.messageBuilder.build(context, messageType);
        if (message.getPayload() != null) {
            context.getMessageProcessors(MessageDirection.INBOUND).forEach(processor -> processor.process(message, context));
            if (this.dataDictionary != null) {
                this.dataDictionary.process(message, context);
            }
            this.controlMessageProcessors.forEach(processor -> processor.process(message, context));
        }
        return message;
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public List<MessageProcessor> getControlMessageProcessors() {
        return this.controlMessageProcessors;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public List<MessageValidator<? extends ValidationContext>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<ValidationContext> getValidationContexts() {
        return this.validationContexts;
    }

    public ValidationProcessor getValidationProcessor() {
        return this.validationProcessor;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public static abstract class ReceiveMessageActionBuilder<T extends ReceiveMessageAction, M extends ReceiveMessageBuilderSupport<T, B, M>, B extends ReceiveMessageActionBuilder<T, M, B>>
    extends MessageBuilderSupport.MessageActionBuilder<T, M, B> {
        private long receiveTimeout = 0L;
        private final Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
        private String messageSelector;
        private final List<MessageValidator<? extends ValidationContext>> validators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        private ValidationProcessor validationProcessor;
        private final List<ValidationContext.Builder<?, ?>> validationContexts = new ArrayList();
        private HeaderValidationContext headerValidationContext;
        private final List<String> validatorNames = new ArrayList<String>();

        public B timeout(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext.Builder<?, ?> validationContext) {
            this.validationContexts.add(validationContext);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext validationContext) {
            return this.validate((ValidationContext.Builder<?, ?>)((ValidationContext.Builder)() -> validationContext));
        }

        public B validate(ValidationContextAdapter adapter) {
            return this.validate(adapter.asValidationContext());
        }

        public B validate(List<ValidationContext.Builder<?, ?>> validationContexts) {
            this.validationContexts.addAll(validationContexts);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationContext.Builder<?, ?> ... validationContexts) {
            return this.validate(Arrays.asList(validationContexts));
        }

        public B selector(String messageSelector) {
            this.messageSelector = messageSelector;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B selector(Map<String, String> messageSelector) {
            this.messageSelectorMap.putAll(messageSelector);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(MessageValidator<? extends ValidationContext> validator) {
            this.validators.add(validator);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final B validators(String ... validators) {
            Arrays.stream(validators).forEach(this::validator);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        @SafeVarargs
        public final B validators(MessageValidator<? extends ValidationContext> ... validators) {
            return this.validators(Arrays.asList(validators));
        }

        public B validators(List<MessageValidator<? extends ValidationContext>> validators) {
            this.validators.addAll(validators);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final B validators(HeaderValidator ... validators) {
            Stream.of(validators).forEach(this::validator);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(String validatorName) {
            this.validatorNames.add(validatorName);
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validator(HeaderValidator validators) {
            Stream.of(validators).forEach(arg_0 -> ((HeaderValidationContext)this.getHeaderValidationContext()).addHeaderValidator(arg_0));
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public B validate(ValidationProcessor processor) {
            this.validationProcessor = processor;
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        @Override
        public B process(MessageProcessor processor) {
            if (processor instanceof VariableExtractor) {
                this.variableExtractors.add((VariableExtractor)processor);
            } else if (processor instanceof ValidationProcessor) {
                this.validate((ValidationProcessor)processor);
            } else {
                this.messageProcessors.add(processor);
            }
            return (B)((ReceiveMessageActionBuilder)this.self);
        }

        public final T build() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = this.getMessageBuilderSupport();
            }
            this.reconcileValidationContexts();
            if (this.referenceResolver != null) {
                if (this.validationProcessor != null && this.validationProcessor instanceof ReferenceResolverAware) {
                    ((ReferenceResolverAware)this.validationProcessor).setReferenceResolver(this.referenceResolver);
                }
                while (!this.validatorNames.isEmpty()) {
                    String validatorName = this.validatorNames.remove(0);
                    Object validator = this.referenceResolver.resolve(validatorName);
                    if (validator instanceof HeaderValidator) {
                        this.getHeaderValidationContext().addHeaderValidator((HeaderValidator)validator);
                        continue;
                    }
                    this.validators.add((MessageValidator<? extends ValidationContext>)((MessageValidator)validator));
                }
                if (((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName() != null) {
                    ((ReceiveMessageBuilderSupport)this.messageBuilderSupport).dictionary((DataDictionary)this.referenceResolver.resolve(((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName(), DataDictionary.class));
                }
            }
            return (T)((ReceiveMessageAction)this.doBuild());
        }

        public HeaderValidationContext getHeaderValidationContext() {
            if (this.headerValidationContext == null) {
                this.headerValidationContext = new HeaderValidationContext();
                this.validate((ValidationContext)this.headerValidationContext);
            }
            return this.headerValidationContext;
        }

        /*
         * Unable to fully structure code
         */
        protected void reconcileValidationContexts() {
            block9: {
                block8: {
                    validationContexts = this.getValidationContexts();
                    if (validationContexts.stream().noneMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(HeaderValidationContext.class))) {
                        this.getHeaderValidationContext();
                    }
                    if (!validationContexts.stream().allMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(HeaderValidationContext.class))) break block8;
                    this.validate((ValidationContext)new XmlMessageValidationContext());
                    this.validate((ValidationContext)new JsonMessageValidationContext());
                    break block9;
                }
                if (!validationContexts.stream().anyMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(JsonPathMessageValidationContext.class))) ** GOTO lbl-1000
                if (validationContexts.stream().noneMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(JsonMessageValidationContext.class))) {
                    this.validate((ValidationContext)new JsonMessageValidationContext());
                } else if (validationContexts.stream().noneMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(XmlMessageValidationContext.class))) {
                    if (validationContexts.stream().noneMatch((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(JsonMessageValidationContext.class)) && (payload = this.getMessagePayload()).isPresent()) {
                        if (MessagePayloadUtils.isXml((String)payload.get())) {
                            this.validate((ValidationContext)new XmlMessageValidationContext());
                        } else if (MessagePayloadUtils.isJson((String)payload.get())) {
                            this.validate((ValidationContext)new JsonMessageValidationContext());
                        }
                    }
                }
            }
            validationContexts.stream().filter((Predicate<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/citrusframework/validation/context/ValidationContext;)Z)(HeaderValidationContext.class)).forEach((java.util.function.Consumer<ValidationContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$reconcileValidationContexts$1(org.citrusframework.validation.context.ValidationContext ), (Lorg/citrusframework/validation/context/ValidationContext;)V)((ReceiveMessageActionBuilder)this));
        }

        protected Optional<String> getMessagePayload() {
            MessagePayloadBuilder payloadBuilder;
            if (this.messageBuilderSupport == null) {
                return Optional.empty();
            }
            if (((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder() instanceof StaticMessageBuilder) {
                Message message = ((StaticMessageBuilder)((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder()).getMessage();
                if (message.getPayload() instanceof String) {
                    return Optional.of((String)message.getPayload(String.class));
                }
            } else if (((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder() instanceof WithPayloadBuilder && (payloadBuilder = ((WithPayloadBuilder)((ReceiveMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder()).getPayloadBuilder()) instanceof DefaultPayloadBuilder) {
                return Optional.ofNullable(((DefaultPayloadBuilder)payloadBuilder).getPayload()).map(Object::toString);
            }
            return Optional.empty();
        }

        public List<ValidationContext> getValidationContexts() {
            return this.validationContexts.stream().map(ValidationContext.Builder::build).collect(Collectors.toList());
        }

        public List<ValidationContext.Builder<?, ?>> getValidationContextBuilders() {
            return this.validationContexts;
        }

        private /* synthetic */ void lambda$reconcileValidationContexts$1(ValidationContext c) {
            ((HeaderValidationContext)c).setHeaderNameIgnoreCase(((ReceiveMessageBuilderSupport)this.getMessageBuilderSupport()).isHeaderNameIgnoreCase());
        }
    }

    public static class ReceiveMessageActionBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveMessageAction, Builder, ReceiveMessageActionBuilderSupport> {
        public ReceiveMessageActionBuilderSupport(Builder delegate) {
            super(delegate);
        }
    }

    public static final class Builder
    extends ReceiveMessageActionBuilder<ReceiveMessageAction, ReceiveMessageActionBuilderSupport, Builder> {
        public static Builder receive() {
            return new Builder();
        }

        public static Builder receive(Endpoint messageEndpoint) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpoint);
            return builder;
        }

        public static Builder receive(String messageEndpointUri) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpointUri);
            return builder;
        }

        @Override
        public ReceiveMessageActionBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new ReceiveMessageActionBuilderSupport((Builder)this.self);
            }
            return (ReceiveMessageActionBuilderSupport)super.getMessageBuilderSupport();
        }

        @Override
        public ReceiveMessageAction doBuild() {
            return new ReceiveMessageAction(this);
        }
    }
}

