/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JavaAction
extends AbstractTestAction {
    private final Object instance;
    private final String className;
    private final String methodName;
    private final List<Object> methodArgs;
    private final List<Object> constructorArgs;
    private static Logger log = LoggerFactory.getLogger(JavaAction.class);

    public JavaAction(Builder builder) {
        super("java", builder);
        this.className = builder.className;
        this.instance = builder.instance;
        this.methodName = builder.methodName;
        this.methodArgs = builder.methodArgs;
        this.constructorArgs = builder.constructorArgs;
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            Object instanceToUse = this.instance != null ? this.instance : this.getObjectInstanceFromClass(context);
            Class[] methodTypes = new Class[this.methodArgs.size()];
            Object[] methodObjects = new Object[this.methodArgs.size()];
            for (int i = 0; i < this.methodArgs.size(); ++i) {
                methodTypes[i] = this.methodArgs.get(i).getClass();
                if (this.methodArgs.get(i).getClass().equals(List.class)) {
                    String[] converted = StringUtils.toStringArray((Collection)((List)this.methodArgs.get(i)));
                    for (int j = 0; j < converted.length; ++j) {
                        converted[j] = context.replaceDynamicContentInString(converted[j]);
                    }
                    methodObjects[i] = converted;
                    continue;
                }
                if (this.methodArgs.get(i).getClass().equals(String[].class)) {
                    String[] params = (String[])this.methodArgs.get(i);
                    String[] converted = Arrays.copyOf(params, params.length);
                    for (int j = 0; j < converted.length; ++j) {
                        converted[j] = context.replaceDynamicContentInString(converted[j]);
                    }
                    methodObjects[i] = converted;
                    continue;
                }
                methodObjects[i] = this.methodArgs.get(i).getClass().equals(String.class) ? context.replaceDynamicContentInString(this.methodArgs.get(i).toString()) : this.methodArgs.get(i);
            }
            this.invokeMethod(instanceToUse, methodTypes, methodObjects);
        }
        catch (RuntimeException e) {
            throw new CitrusRuntimeException("Failed to invoke Java method due to runtime error", (Throwable)e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to invoke Java method", (Throwable)e);
        }
    }

    private void invokeMethod(Object instance, Class<?>[] methodTypes, Object[] methodObjects) throws IllegalArgumentException, InvocationTargetException, IllegalAccessException, CitrusRuntimeException {
        Method methodToRun = ReflectionUtils.findMethod(instance.getClass(), (String)this.methodName, (Class[])methodTypes);
        if (methodToRun == null) {
            throw new CitrusRuntimeException("Unable to find method '" + this.methodName + "(" + StringUtils.arrayToCommaDelimitedString((Object[])methodTypes) + ")' for class '" + instance.getClass() + "'");
        }
        log.info("Invoking method '" + methodToRun.toString() + "' on instance '" + instance.getClass() + "'");
        methodToRun.invoke(instance, methodObjects);
    }

    private Object getObjectInstanceFromClass(TestContext context) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!StringUtils.hasText((String)this.className)) {
            throw new CitrusRuntimeException("Neither class name nor object instance reference is set for Java reflection call");
        }
        log.info("Instantiating class for name '" + this.className + "'");
        Class<?> classToRun = Class.forName(this.className);
        Class[] constructorTypes = new Class[this.constructorArgs.size()];
        Object[] constructorObjects = new Object[this.constructorArgs.size()];
        for (int i = 0; i < this.constructorArgs.size(); ++i) {
            constructorTypes[i] = this.constructorArgs.get(i).getClass();
            constructorObjects[i] = this.constructorArgs.get(i).getClass().equals(String.class) ? context.replaceDynamicContentInString(this.constructorArgs.get(i).toString()) : this.constructorArgs.get(i);
        }
        Constructor<?> constr = classToRun.getConstructor(constructorTypes);
        return constr.newInstance(constructorObjects);
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Object> getMethodArgs() {
        return this.methodArgs;
    }

    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<JavaAction, Builder> {
        private Object instance;
        private String className;
        private String methodName;
        private final List<Object> methodArgs = new ArrayList<Object>();
        private final List<Object> constructorArgs = new ArrayList<Object>();

        public static Builder java(String className) {
            Builder builder = new Builder();
            builder.className(className);
            return builder;
        }

        public static Builder java(Class<?> clazz) {
            Builder builder = new Builder();
            builder.className(clazz.getSimpleName());
            return builder;
        }

        public static Builder java(Object instance) {
            Builder builder = new Builder();
            builder.instance(instance);
            return builder;
        }

        public Builder instance(Object instance) {
            this.instance = instance;
            return this;
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder method(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder constructorArgs(Object ... constructorArgs) {
            return this.constructorArgs(Arrays.asList(constructorArgs));
        }

        public Builder constructorArgs(List<Object> constructorArgs) {
            this.constructorArgs.addAll(constructorArgs);
            return this;
        }

        public Builder methodArgs(Object ... methodArgs) {
            return this.methodArgs(Arrays.asList(methodArgs));
        }

        public Builder methodArgs(List<Object> methodArgs) {
            this.methodArgs.addAll(methodArgs);
            return this;
        }

        public JavaAction build() {
            return new JavaAction(this);
        }
    }
}

