/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.actions.NoopTestAction;
import org.citrusframework.container.TestActionContainer;

public abstract class AbstractTestContainerBuilder<T extends TestActionContainer, S extends TestActionContainerBuilder<T, S>>
extends AbstractTestActionBuilder<T, S>
implements TestActionContainerBuilder<T, S> {
    protected final List<TestActionBuilder<?>> actions = new ArrayList();

    public S actions(TestAction ... actions) {
        return this.actions(Stream.of(actions).filter(action -> !(action instanceof NoopTestAction)).map(action -> () -> action).collect(Collectors.toList()).toArray(new TestActionBuilder[0]));
    }

    public S actions(TestActionBuilder<?> ... actions) {
        for (int i = 0; i < actions.length; ++i) {
            TestActionBuilder<?> current = actions[i];
            if (current.build() instanceof NoopTestAction) continue;
            if (this.actions.size() == i) {
                this.actions.add(current);
                continue;
            }
            if (this.resolveActionBuilder(this.actions.get(i)).equals(this.resolveActionBuilder(current))) continue;
            this.actions.add(i, current);
        }
        return (S)((TestActionContainerBuilder)this.self);
    }

    private TestActionBuilder<?> resolveActionBuilder(TestActionBuilder<?> builder) {
        if (builder instanceof TestActionBuilder.DelegatingTestActionBuilder) {
            return this.resolveActionBuilder(((TestActionBuilder.DelegatingTestActionBuilder)builder).getDelegate());
        }
        return builder;
    }

    public T build() {
        T container = this.doBuild();
        container.setActions(this.actions.stream().map(TestActionBuilder::build).filter(action -> !(action instanceof NoopTestAction)).collect(Collectors.toList()));
        return container;
    }

    protected abstract T doBuild();

    public List<TestActionBuilder<?>> getActions() {
        return this.actions;
    }

    public static <T extends TestActionContainer, B extends TestActionContainerBuilder<T, B>> TestActionContainerBuilder<T, B> container(final T container) {
        return new AbstractTestContainerBuilder<T, B>(){

            @Override
            public T doBuild() {
                return container;
            }

            @Override
            public T build() {
                if (container.getActions().size() > 0) {
                    return container;
                }
                return super.build();
            }
        };
    }
}

