/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.xml;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.builder.WithExpressions;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.springframework.util.StringUtils;

public class XpathMessageValidationContext
extends XmlMessageValidationContext {
    private final Map<String, Object> xPathExpressions;

    public XpathMessageValidationContext() {
        this(new Builder());
    }

    public XpathMessageValidationContext(Builder builder) {
        super(builder);
        this.xPathExpressions = builder.expressions;
    }

    public Map<String, Object> getXpathExpressions() {
        return this.xPathExpressions;
    }

    public static boolean isXpathExpression(String pathExpression) {
        return StringUtils.hasText((String)pathExpression) && pathExpression.startsWith("/");
    }

    public static final class Builder
    extends XmlMessageValidationContext.XmlValidationContextBuilder<XpathMessageValidationContext, Builder>
    implements WithExpressions<Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder xpath() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public XpathMessageValidationContext build() {
            return new XpathMessageValidationContext(this);
        }
    }
}

