/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher;

import org.citrusframework.validation.matcher.ValidationMatcher;
import org.citrusframework.validation.matcher.ValidationMatcherLibrary;
import org.citrusframework.validation.matcher.core.ContainsIgnoreCaseValidationMatcher;
import org.citrusframework.validation.matcher.core.ContainsValidationMatcher;
import org.citrusframework.validation.matcher.core.CreateVariableValidationMatcher;
import org.citrusframework.validation.matcher.core.DatePatternValidationMatcher;
import org.citrusframework.validation.matcher.core.DateRangeValidationMatcher;
import org.citrusframework.validation.matcher.core.EmptyValidationMatcher;
import org.citrusframework.validation.matcher.core.EndsWithValidationMatcher;
import org.citrusframework.validation.matcher.core.EqualsIgnoreCaseValidationMatcher;
import org.citrusframework.validation.matcher.core.GreaterThanValidationMatcher;
import org.citrusframework.validation.matcher.core.IgnoreNewLineValidationMatcher;
import org.citrusframework.validation.matcher.core.IgnoreValidationMatcher;
import org.citrusframework.validation.matcher.core.IsNumberValidationMatcher;
import org.citrusframework.validation.matcher.core.LowerThanValidationMatcher;
import org.citrusframework.validation.matcher.core.MatchesValidationMatcher;
import org.citrusframework.validation.matcher.core.NotEmptyValidationMatcher;
import org.citrusframework.validation.matcher.core.NotNullValidationMatcher;
import org.citrusframework.validation.matcher.core.NullValidationMatcher;
import org.citrusframework.validation.matcher.core.StartsWithValidationMatcher;
import org.citrusframework.validation.matcher.core.StringLengthValidationMatcher;
import org.citrusframework.validation.matcher.core.TrimAllWhitespacesValidationMatcher;
import org.citrusframework.validation.matcher.core.TrimValidationMatcher;
import org.citrusframework.validation.matcher.core.WeekdayValidationMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidationMatcherLibrary
extends ValidationMatcherLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValidationMatcherLibrary.class);

    public DefaultValidationMatcherLibrary() {
        this.setName("citrusValidationMatcherLibrary");
        this.getMembers().put("equalsIgnoreCase", new EqualsIgnoreCaseValidationMatcher());
        this.getMembers().put("ignoreNewLine", new IgnoreNewLineValidationMatcher());
        this.getMembers().put("trim", new TrimValidationMatcher());
        this.getMembers().put("trimAllWhitespaces", new TrimAllWhitespacesValidationMatcher());
        this.getMembers().put("contains", new ContainsValidationMatcher());
        this.getMembers().put("containsIgnoreCase", new ContainsIgnoreCaseValidationMatcher());
        this.getMembers().put("greaterThan", new GreaterThanValidationMatcher());
        this.getMembers().put("lowerThan", new LowerThanValidationMatcher());
        this.getMembers().put("startsWith", new StartsWithValidationMatcher());
        this.getMembers().put("endsWith", new EndsWithValidationMatcher());
        this.getMembers().put("isNumber", new IsNumberValidationMatcher());
        this.getMembers().put("matches", new MatchesValidationMatcher());
        this.getMembers().put("matchesDatePattern", new DatePatternValidationMatcher());
        this.getMembers().put("isWeekday", new WeekdayValidationMatcher());
        this.getMembers().put("variable", new CreateVariableValidationMatcher());
        this.getMembers().put("dateRange", new DateRangeValidationMatcher());
        this.getMembers().put("empty", new EmptyValidationMatcher());
        this.getMembers().put("notEmpty", new NotEmptyValidationMatcher());
        this.getMembers().put("null", new NullValidationMatcher());
        this.getMembers().put("notNull", new NotNullValidationMatcher());
        this.getMembers().put("ignore", new IgnoreValidationMatcher());
        this.getMembers().put("hasLength", new StringLengthValidationMatcher());
        this.lookupValidationMatchers();
    }

    private void lookupValidationMatchers() {
        ValidationMatcher.lookup().forEach((k, m) -> {
            this.getMembers().put(k, m);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Register message matcher '%s' as %s", k, m.getClass()));
            }
        });
    }
}

