/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.AbstractMessageProcessor;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageType;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

public class GzipMessageProcessor
extends AbstractMessageProcessor {
    private final Charset encoding;

    public GzipMessageProcessor() {
        this(Builder.toGzip());
    }

    public GzipMessageProcessor(Builder builder) {
        this.encoding = builder.encoding;
    }

    protected void processMessage(Message message, TestContext context) {
        if (message.getPayload() instanceof GZIPOutputStream) {
            return;
        }
        try {
            if (message.getPayload() instanceof String) {
                message.setPayload((Object)this.getZipped(context.replaceDynamicContentInString((String)message.getPayload(String.class)).getBytes(this.encoding)));
            } else if (message.getPayload() instanceof Resource) {
                message.setPayload((Object)this.getZipped(FileCopyUtils.copyToByteArray((InputStream)((Resource)message.getPayload(Resource.class)).getInputStream())));
            } else if (message.getPayload() instanceof InputStream) {
                message.setPayload((Object)this.getZipped(FileCopyUtils.copyToByteArray((InputStream)((InputStream)message.getPayload(InputStream.class)))));
            } else {
                message.setPayload((Object)this.getZipped((byte[])message.getPayload(byte[].class)));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to gzip message payload", (Throwable)e);
        }
        message.setType(MessageType.GZIP.name());
    }

    private byte[] getZipped(byte[] in) throws IOException {
        try (ByteArrayOutputStream zipped = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(zipped);){
                StreamUtils.copy((byte[])in, (OutputStream)gzipOutputStream);
            }
            byte[] byArray = zipped.toByteArray();
            return byArray;
        }
    }

    public static final class Builder
    implements MessageProcessor.Builder<GzipMessageProcessor, Builder> {
        private Charset encoding = Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING);

        public static Builder toGzip() {
            return new Builder();
        }

        public Builder encoding(String charsetName) {
            return this.encoding(Charset.forName(charsetName));
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public GzipMessageProcessor build() {
            return new GzipMessageProcessor(this);
        }
    }
}

