/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointAdapter;
import org.citrusframework.endpoint.direct.DirectEndpoint;
import org.citrusframework.endpoint.direct.DirectSyncEndpoint;
import org.citrusframework.endpoint.direct.DirectSyncEndpointConfiguration;
import org.citrusframework.endpoint.direct.DirectSyncProducer;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectEndpointAdapter
extends AbstractEndpointAdapter {
    private final DirectSyncEndpoint endpoint;
    private final DirectSyncProducer producer;
    private final DirectSyncEndpointConfiguration endpointConfiguration;
    private static final Logger log = LoggerFactory.getLogger(DirectEndpointAdapter.class);

    public DirectEndpointAdapter(DirectSyncEndpoint endpoint) {
        this.endpointConfiguration = endpoint.getEndpointConfiguration();
        endpoint.setName(this.getName());
        this.producer = new DirectSyncProducer(endpoint.getProducerName(), this.endpointConfiguration);
        this.endpoint = endpoint;
    }

    public DirectEndpointAdapter(DirectSyncEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        this.endpoint = new DirectSyncEndpoint(endpointConfiguration);
        this.endpoint.setName(this.getName());
        this.producer = new DirectSyncProducer(this.endpoint.getProducerName(), endpointConfiguration);
    }

    @Override
    public Message handleMessageInternal(Message request) {
        log.debug("Forwarding request to message queue ...");
        TestContext context = this.getTestContext();
        Message replyMessage = null;
        try {
            this.producer.send(request, context);
            replyMessage = this.endpointConfiguration.getCorrelator() != null ? this.producer.receive(this.endpointConfiguration.getCorrelator().getCorrelationKey(request), context, this.endpointConfiguration.getTimeout()) : this.producer.receive(context, this.endpointConfiguration.getTimeout());
        }
        catch (ActionTimeoutException e) {
            log.warn(e.getMessage());
        }
        return replyMessage;
    }

    public DirectEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DirectSyncEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }
}

