/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.direct.DirectEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.selector.DelegatingMessageSelector;
import org.citrusframework.messaging.AbstractSelectiveMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DirectConsumer
extends AbstractSelectiveMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(DirectConsumer.class);
    private final DirectEndpointConfiguration endpointConfiguration;

    public DirectConsumer(String name, DirectEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message;
        MessageQueue destinationQueue = this.getDestinationQueue(context);
        Object destinationQueueName = StringUtils.hasText((String)selector) ? this.getDestinationQueueName() + "(" + selector + ")" : this.getDestinationQueueName();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Receiving message from queue: '%s'", destinationQueueName));
        }
        if (StringUtils.hasText((String)selector)) {
            DelegatingMessageSelector messageSelector = new DelegatingMessageSelector(selector, context);
            message = timeout <= 0L ? destinationQueue.receive((MessageSelector)messageSelector) : destinationQueue.receive((MessageSelector)messageSelector, timeout);
        } else {
            message = timeout <= 0L ? destinationQueue.receive() : destinationQueue.receive(timeout);
        }
        if (message == null) {
            throw new MessageTimeoutException(timeout, (String)destinationQueueName);
        }
        log.info(String.format("Received message from queue: '%s'", destinationQueueName));
        return message;
    }

    protected MessageQueue getDestinationQueue(TestContext context) {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getQueueName())) {
            return this.resolveQueueName(this.endpointConfiguration.getQueueName(), context);
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected String getDestinationQueueName() {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue().toString();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getQueueName())) {
            return this.endpointConfiguration.getQueueName();
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected MessageQueue resolveQueueName(String queueName, TestContext context) {
        if (context.getReferenceResolver() != null) {
            return (MessageQueue)context.getReferenceResolver().resolve(queueName, MessageQueue.class);
        }
        throw new CitrusRuntimeException("Unable to resolve message queue - missing proper reference resolver in context");
    }
}

