/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractIteratingContainerBuilder;
import org.citrusframework.container.AbstractIteratingActionContainer;
import org.citrusframework.container.IteratingConditionExpression;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOnErrorUntilTrue
extends AbstractIteratingActionContainer {
    private final Long autoSleep;
    private static final Logger LOG = LoggerFactory.getLogger(RepeatOnErrorUntilTrue.class);

    public RepeatOnErrorUntilTrue(Builder builder) {
        super("repeat-on-error", builder);
        this.autoSleep = builder.autoSleep;
    }

    @Override
    public void executeIteration(TestContext context) {
        CitrusRuntimeException exception = null;
        while (!this.checkCondition(context)) {
            try {
                exception = null;
                this.executeActions(context);
                break;
            }
            catch (CitrusRuntimeException e) {
                exception = e;
                LOG.info("Caught exception of type " + ((Object)((Object)e)).getClass().getName() + " '" + e.getMessage() + "' - performing retry #" + this.index);
                this.doAutoSleep();
                ++this.index;
            }
        }
        if (exception != null) {
            LOG.info("All retries failed - raising exception " + ((Object)((Object)exception)).getClass().getName());
            throw exception;
        }
    }

    private void doAutoSleep() {
        if (this.autoSleep > 0L) {
            LOG.info("Sleeping " + this.autoSleep + " milliseconds");
            try {
                Thread.sleep(this.autoSleep);
            }
            catch (InterruptedException e) {
                LOG.error("Error during doc generation", (Throwable)e);
            }
            LOG.info("Returning after " + this.autoSleep + " milliseconds");
        }
    }

    public Long getAutoSleep() {
        return this.autoSleep;
    }

    public static class Builder
    extends AbstractIteratingContainerBuilder<RepeatOnErrorUntilTrue, Builder> {
        private Long autoSleep = 1000L;

        public static Builder repeatOnError() {
            return new Builder();
        }

        public Builder until(String condition) {
            this.condition(condition);
            return this;
        }

        public Builder until(IteratingConditionExpression condition) {
            this.condition(condition);
            return this;
        }

        public Builder autoSleep(long autoSleepInMillis) {
            this.autoSleep = autoSleepInMillis;
            return this;
        }

        @Override
        public RepeatOnErrorUntilTrue doBuild() {
            return new RepeatOnErrorUntilTrue(this);
        }
    }
}

