/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopTimerAction
extends AbstractTestAction {
    private static Logger log = LoggerFactory.getLogger(StopTimerAction.class);
    private final String timerId;

    public StopTimerAction(Builder builder) {
        super("stop-timer", builder);
        this.timerId = builder.timerId;
    }

    public String getTimerId() {
        return this.timerId;
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.timerId != null) {
            boolean success = context.stopTimer(this.timerId);
            log.info(String.format("Stopping timer %s - stop successful: %s", this.timerId, success));
        } else {
            context.stopTimers();
            log.info("Stopping all timers");
        }
    }

    public static final class Builder
    extends AbstractTestActionBuilder<StopTimerAction, Builder> {
        private String timerId;

        public static Builder stopTimers() {
            return new Builder();
        }

        public static Builder stopTimer(String timerId) {
            Builder builder = new Builder();
            builder.id(timerId);
            return builder;
        }

        public Builder id(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public StopTimerAction build() {
            return new StopTimerAction(this);
        }
    }
}

