/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.context;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.validation.HeaderValidator;
import org.citrusframework.validation.context.HeaderValidationContextBuilder;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.context.ValidationStatus;

public class HeaderValidationContext
implements ValidationContext {
    private final List<HeaderValidator> validators;
    private final List<String> validatorNames;
    private final boolean headerNameIgnoreCase;
    private ValidationStatus status = ValidationStatus.UNKNOWN;

    public HeaderValidationContext() {
        this(new Builder());
    }

    public HeaderValidationContext(Builder builder) {
        this.validators = builder.validators;
        this.validatorNames = builder.validatorNames;
        this.headerNameIgnoreCase = builder.headerNameIgnoreCase;
    }

    public boolean isHeaderNameIgnoreCase() {
        return this.headerNameIgnoreCase;
    }

    public void addHeaderValidator(HeaderValidator validator) {
        this.validators.add(validator);
    }

    public void addHeaderValidator(String validatorName) {
        this.validatorNames.add(validatorName);
    }

    public List<HeaderValidator> getValidators() {
        return this.validators;
    }

    public List<String> getValidatorNames() {
        return this.validatorNames;
    }

    @Override
    public void updateStatus(ValidationStatus status) {
        if (status != ValidationStatus.FAILED) {
            this.status = status;
        }
    }

    @Override
    public ValidationStatus getStatus() {
        return this.status;
    }

    public static final class Builder
    implements HeaderValidationContextBuilder<HeaderValidationContext, Builder> {
        private final List<HeaderValidator> validators = new ArrayList<HeaderValidator>();
        private final List<String> validatorNames = new ArrayList<String>();
        private boolean headerNameIgnoreCase = false;

        @Override
        public Builder ignoreCase(boolean headerNameIgnoreCase) {
            this.headerNameIgnoreCase = headerNameIgnoreCase;
            return this;
        }

        @Override
        public Builder validator(HeaderValidator validator) {
            this.validators.add(validator);
            return this;
        }

        @Override
        public Builder validator(String validatorName) {
            this.validatorNames.add(validatorName);
            return this;
        }

        @Override
        public Builder validators(List<HeaderValidator> validators) {
            this.validators.addAll(validators);
            return this;
        }

        @Override
        public Builder validatorNames(List<String> validatorNames) {
            this.validatorNames.addAll(validatorNames);
            return this;
        }

        @Override
        public HeaderValidationContext build() {
            return new HeaderValidationContext(this);
        }
    }
}

