/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValueMatcher {
    public static final Logger logger = LoggerFactory.getLogger(ValueMatcher.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/value/matcher";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/value/matcher");
    public static final Map<String, ValueMatcher> validators = new ConcurrentHashMap<String, ValueMatcher>();

    public static Map<String, ValueMatcher> lookup() {
        if (validators.isEmpty()) {
            validators.putAll(TYPE_RESOLVER.resolveAll());
            if (logger.isDebugEnabled()) {
                validators.forEach((k, v) -> logger.debug("Found validator '{}' as {}", k, v.getClass()));
            }
        }
        return validators;
    }

    public static Optional<ValueMatcher> lookup(String validator) {
        try {
            ValueMatcher instance = (ValueMatcher)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve value matcher from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)validator);
            return Optional.empty();
        }
    }

    public boolean supports(Class<?> var1);

    public boolean validate(Object var1, Object var2, TestContext var3);
}

