/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.List;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.MessageValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTextEqualsMessageValidator
extends DefaultMessageValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTextEqualsMessageValidator.class);
    private boolean normalizeLineEndings = true;
    private boolean trim = true;

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) {
        if (controlMessage == null || controlMessage.getPayload() == null || controlMessage.getPayload(String.class).isEmpty()) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        logger.debug("Start to verify message payload ...");
        String controlPayload = controlMessage.getPayload(String.class);
        String receivedPayload = receivedMessage.getPayload(String.class);
        if (this.trim) {
            controlPayload = controlPayload.trim();
            receivedPayload = receivedPayload.trim();
        }
        if (this.normalizeLineEndings) {
            controlPayload = DefaultTextEqualsMessageValidator.normalizeLineEndings(controlPayload);
            receivedPayload = DefaultTextEqualsMessageValidator.normalizeLineEndings(receivedPayload);
        }
        if (!receivedPayload.equals(controlPayload)) {
            throw new ValidationException("Validation failed - message payload not equal " + this.getFirstDiff(receivedPayload, controlPayload));
        }
        logger.debug("Message validation successful: All values OK");
    }

    public String getFirstDiff(String received, String control) {
        int position;
        for (position = 0; position < received.length() && position < control.length() && received.charAt(position) == control.charAt(position); ++position) {
        }
        if (position < control.length() || position < received.length()) {
            int controlEnd = Math.min(position + 25, control.length());
            int receivedEnd = Math.min(position + 25, received.length());
            return String.format("at position %d expected '%s', but was '%s'", position + 1, control.substring(position, controlEnd), received.substring(position, receivedEnd));
        }
        return "";
    }

    public DefaultTextEqualsMessageValidator normalizeLineEndings() {
        this.normalizeLineEndings = true;
        return this;
    }

    public DefaultTextEqualsMessageValidator enableTrim() {
        this.trim = true;
        return this;
    }

    @Override
    public ValidationContext findValidationContext(List<ValidationContext> validationContexts) {
        Optional<ValidationContext> messageValidationContext = validationContexts.stream().filter(MessageValidationContext.class::isInstance).findFirst();
        return messageValidationContext.orElseGet(() -> super.findValidationContext(validationContexts));
    }

    private static String normalizeLineEndings(String text) {
        return text.replace("\r\n", "\n").replace("&#13;", "");
    }
}

