/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.citrusframework.message.MessageType;

final class MediaTypeMapper {
    private static final Map<String, MessageType> MEDIA_TYPE_TO_CITRUS;

    private MediaTypeMapper() {
    }

    static MessageType mapToMessageType(@Nullable String contentTypeHeader, @Nullable String encodingHeader) {
        String enc;
        if (contentTypeHeader == null) {
            return null;
        }
        String ct = contentTypeHeader.split(";", 2)[0].trim().toLowerCase();
        String string = enc = encodingHeader != null ? encodingHeader.trim().toLowerCase() : "";
        if ("base64".equals(enc)) {
            if ("application/octet-stream".equals(ct)) {
                return MessageType.BINARY_BASE64;
            }
            if ("application/gzip".equals(ct) || "application/x-gzip".equals(ct)) {
                return MessageType.GZIP_BASE64;
            }
        }
        return MEDIA_TYPE_TO_CITRUS.get(ct);
    }

    static {
        LinkedHashMap<String, MessageType> m = new LinkedHashMap<String, MessageType>();
        m.put("application/xml", MessageType.XML);
        m.put("text/xml", MessageType.XML);
        m.put("application/xhtml+xml", MessageType.XHTML);
        m.put("text/csv", MessageType.CSV);
        m.put("application/json", MessageType.JSON);
        m.put("application/x-yaml", MessageType.YAML);
        m.put("application/yaml", MessageType.YAML);
        m.put("text/plain", MessageType.PLAINTEXT);
        m.put("application/octet-stream", MessageType.BINARY);
        m.put("application/gzip", MessageType.GZIP);
        m.put("application/x-gzip", MessageType.GZIP);
        m.put("application/edifact", MessageType.MSCONS);
        m.put("application/edifact+mscons", MessageType.MSCONS);
        m.put("application/edifact;profile=mscons", MessageType.MSCONS);
        m.put("application/pdf", MessageType.BINARY);
        m.put("application/zip", MessageType.BINARY);
        m.put("application/x-7z-compressed", MessageType.BINARY);
        m.put("image/png", MessageType.BINARY);
        m.put("image/jpeg", MessageType.BINARY);
        m.put("image/gif", MessageType.BINARY);
        MEDIA_TYPE_TO_CITRUS = Collections.unmodifiableMap(m);
    }
}

