/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.citrusframework.annotations.CitrusEndpoint;
import org.citrusframework.annotations.CitrusEndpointConfig;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.spi.BindToRegistry;
import org.citrusframework.spi.ReferenceRegistry;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CitrusEndpointAnnotations {
    private static final Logger logger = LoggerFactory.getLogger(CitrusEndpointAnnotations.class);

    private CitrusEndpointAnnotations() {
    }

    public static void injectEndpoints(Object target, TestContext context) {
        ReflectionHelper.doWithFields(target.getClass(), field -> {
            if (!field.isAnnotationPresent(CitrusEndpoint.class) || !Endpoint.class.isAssignableFrom(field.getType())) {
                return;
            }
            logger.debug("Injecting Citrus endpoint on test class field '{}'", (Object)field.getName());
            CitrusEndpoint endpointAnnotation = field.getAnnotation(CitrusEndpoint.class);
            ReferenceResolver referenceResolver = context.getReferenceResolver();
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(CitrusEndpointConfig.class) == null) continue;
                Endpoint endpoint = context.getEndpointFactory().create(CitrusEndpointAnnotations.getEndpointName(field), annotation, context);
                ReflectionHelper.setField(field, target, endpoint);
                if (field.isAnnotationPresent(BindToRegistry.class)) {
                    String endpointName = ReferenceRegistry.getName(field.getAnnotation(BindToRegistry.class), endpoint.getName());
                    referenceResolver.bind(endpointName, endpoint);
                }
                return;
            }
            if (endpointAnnotation.properties().length > 0) {
                ReflectionHelper.setField(field, target, context.getEndpointFactory().create(CitrusEndpointAnnotations.getEndpointName(field), endpointAnnotation, field.getType(), context));
            } else if (endpointAnnotation.name() != null && !endpointAnnotation.name().isBlank() && referenceResolver.isResolvable(endpointAnnotation.name())) {
                ReflectionHelper.setField(field, target, referenceResolver.resolve(endpointAnnotation.name(), field.getType()));
            } else if (referenceResolver.isResolvable(field.getName())) {
                ReflectionHelper.setField(field, target, referenceResolver.resolve(field.getName(), field.getType()));
            } else {
                ReflectionHelper.setField(field, target, referenceResolver.resolve(field.getType()));
            }
        });
    }

    private static String getEndpointName(Field field) {
        if (field.getAnnotation(CitrusEndpoint.class) != null && field.getAnnotation(CitrusEndpoint.class).name() != null && !field.getAnnotation(CitrusEndpoint.class).name().isBlank()) {
            return field.getAnnotation(CitrusEndpoint.class).name();
        }
        return field.getName();
    }
}

