/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.CitrusSettings;

public class StringSource
extends StreamSource {
    private final String content;
    private final String encoding;

    public StringSource(String content) {
        this(content, CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public StringSource(String content, String encoding) {
        this.content = content;
        this.encoding = encoding;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.content);
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.content.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.content;
    }

    public String getContent() {
        return this.content;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

