/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.NoSuchFunctionLibraryException;
import org.citrusframework.functions.FunctionLibrary;

public class FunctionRegistry {
    private List<FunctionLibrary> functionLibraries = new ArrayList<FunctionLibrary>();

    public boolean isFunction(String variableExpression) {
        if (variableExpression == null || variableExpression.isEmpty()) {
            return false;
        }
        for (FunctionLibrary lib : this.functionLibraries) {
            if (!variableExpression.startsWith(lib.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public FunctionLibrary getLibraryForPrefix(String functionPrefix) {
        for (FunctionLibrary functionLibrary : this.functionLibraries) {
            if (!functionLibrary.getPrefix().equals(functionPrefix)) continue;
            return functionLibrary;
        }
        throw new NoSuchFunctionLibraryException("Can not find function library for prefix " + functionPrefix);
    }

    public void addFunctionLibrary(FunctionLibrary functionLibrary) {
        boolean prefixAlreadyUsed = this.functionLibraries.stream().anyMatch(lib -> lib.getPrefix().equals(functionLibrary.getPrefix()));
        if (prefixAlreadyUsed) {
            throw new CitrusRuntimeException(String.format("Function library prefix '%s' is already bound to another instance. Please choose another prefix.", functionLibrary.getPrefix()));
        }
        this.functionLibraries.add(functionLibrary);
    }

    public void setFunctionLibraries(List<FunctionLibrary> functionLibraries) {
        this.functionLibraries = functionLibraries;
    }

    public List<FunctionLibrary> getFunctionLibraries() {
        return this.functionLibraries;
    }
}

