/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable;

import java.util.Iterator;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.variable.SegmentVariableExtractor;
import org.citrusframework.variable.VariableExpressionSegmentMatcher;

public class VariableExpressionIterator
implements Iterator<VariableSegment> {
    private final VariableExpressionSegmentMatcher matcher;
    private final TestContext testContext;
    private final List<SegmentVariableExtractor> segmentValueExtractors;
    private VariableSegment nextSegment;

    public VariableExpressionIterator(String variableExpression, TestContext testContext, List<SegmentVariableExtractor> segmentValueExtractors) {
        this.testContext = testContext;
        this.segmentValueExtractors = segmentValueExtractors;
        this.matcher = new VariableExpressionSegmentMatcher(variableExpression);
        if (!this.matcher.nextMatch()) {
            throw new CitrusRuntimeException(String.format("Cannot match a segment on variableExpression: %s", variableExpression));
        }
        this.nextSegment = this.createSegmentValue(testContext.getVariables());
    }

    @Override
    public boolean hasNext() {
        return this.nextSegment != null;
    }

    @Override
    public VariableSegment next() {
        VariableSegment currentSegment = this.nextSegment;
        this.nextSegment = this.matcher.nextMatch() ? this.createSegmentValue(currentSegment.getSegmentValue()) : null;
        return currentSegment;
    }

    private VariableSegment createSegmentValue(Object parentValue) {
        Object segmentValue = this.segmentValueExtractors.stream().filter(extractor -> extractor.canExtract(this.testContext, parentValue, this.matcher)).findFirst().map(extractor -> extractor.extractValue(this.testContext, parentValue, this.matcher)).orElse(null);
        return new VariableSegment(this.matcher.getSegmentExpression(), this.matcher.getSegmentIndex(), segmentValue);
    }

    public static Object getLastExpressionValue(String variableExpression, TestContext testContext, List<SegmentVariableExtractor> extractors) {
        VariableSegment segment = null;
        VariableExpressionIterator iterator = new VariableExpressionIterator(variableExpression, testContext, extractors);
        while (iterator.hasNext()) {
            segment = iterator.next();
        }
        return segment != null ? segment.getSegmentValue() : null;
    }

    public static class VariableSegment {
        private final String name;
        private final int index;
        private final Object segmentValue;

        public VariableSegment(String name, int index, Object segmentValue) {
            this.name = name;
            this.index = index;
            this.segmentValue = segmentValue;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getSegmentValue() {
            return this.segmentValue;
        }
    }
}

