/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.context;

import java.util.HashSet;
import java.util.Set;
import org.citrusframework.validation.context.SchemaValidationContext;
import org.citrusframework.validation.context.ValidationContext;

public interface MessageValidationContext
extends ValidationContext,
SchemaValidationContext {
    public Set<String> getIgnoreExpressions();

    public static abstract class Builder<T extends MessageValidationContext, S extends Builder<T, S>>
    implements ValidationContext.Builder<T, Builder<T, S>>,
    SchemaValidationContext.Builder<Builder<T, S>> {
        protected final S self;
        protected final Set<String> ignoreExpressions = new HashSet<String>();
        protected boolean schemaValidation = true;
        protected String schemaRepository;
        protected String schema;

        protected Builder() {
            this.self = this;
        }

        @Override
        public S schemaValidation(boolean enabled) {
            this.schemaValidation = enabled;
            return this.self;
        }

        @Override
        public S schema(String schemaName) {
            this.schema = schemaName;
            return this.self;
        }

        @Override
        public S schemaRepository(String schemaRepository) {
            this.schemaRepository = schemaRepository;
            return this.self;
        }

        public S ignore(String path) {
            this.ignoreExpressions.add(path);
            return this.self;
        }

        public S ignore(Set<String> paths) {
            this.ignoreExpressions.addAll(paths);
            return this.self;
        }
    }
}

