/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.List;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.context.ValidationStatus;

public abstract class AbstractMessageValidator<T extends ValidationContext>
implements MessageValidator<T> {
    @Override
    public final void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, List<ValidationContext> validationContexts) throws ValidationException {
        T validationContext = this.findValidationContext(validationContexts);
        if (validationContext != null) {
            try {
                this.validateMessage(receivedMessage, controlMessage, context, validationContext);
                validationContext.updateStatus(ValidationStatus.PASSED);
            }
            catch (ValidationException e) {
                validationContext.updateStatus(ValidationStatus.FAILED);
                throw e;
            }
        }
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, T validationContext) {
    }

    protected abstract Class<T> getRequiredValidationContextType();

    public T findValidationContext(List<ValidationContext> validationContexts) {
        Optional<ValidationContext> matchingValidationContext = validationContexts.stream().filter(this.getRequiredValidationContextType()::isInstance).map(this.getRequiredValidationContextType()::cast).findFirst();
        return (T)((ValidationContext)matchingValidationContext.orElse(null));
    }
}

