/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

public enum MessageType {
    UNSPECIFIED,
    XML,
    XHTML,
    CSV,
    JSON,
    PLAINTEXT,
    BINARY,
    BINARY_BASE64,
    GZIP,
    GZIP_BASE64,
    MSCONS;

    public static final String FORM_URL_ENCODED = "x-www-form-urlencoded";

    public static boolean knows(String messageTypeName) {
        for (MessageType messageType : MessageType.values()) {
            if (!messageType.toString().equalsIgnoreCase(messageTypeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBinary(String messageType) {
        return GZIP.name().equalsIgnoreCase(messageType) || BINARY.name().equalsIgnoreCase(messageType);
    }

    public static boolean isXml(String messageType) {
        return XML.name().equalsIgnoreCase(messageType) || XHTML.name().equalsIgnoreCase(messageType);
    }
}

