/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main;

import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TestEngine {
    public static final Logger logger = LoggerFactory.getLogger(TestEngine.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/engine";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/engine");

    public void run();

    public static TestEngine lookup(TestRunConfiguration configuration) {
        TestEngine testEngine;
        try {
            testEngine = (TestEngine)TYPE_RESOLVER.resolve(configuration.getEngine(), configuration);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to resolve Citrus engine from resource '%s/%s'", RESOURCE_PATH, configuration.getEngine()), e);
        }
        if (testEngine == null) {
            throw new CitrusRuntimeException(String.format("Failed to resolve Citrus engine from resource '%s/%s'", RESOURCE_PATH, configuration.getEngine()));
        }
        logger.debug("Using Citrus engine '{}' as {}", (Object)configuration.getEngine(), (Object)testEngine);
        return testEngine;
    }
}

