/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.citrusframework.annotations.CitrusEndpoint;
import org.citrusframework.annotations.CitrusEndpointConfig;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.endpoint.EndpointComponent;
import org.citrusframework.endpoint.EndpointFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointFactory
implements EndpointFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointFactory.class);
    private final Map<String, Endpoint> endpointCache = new ConcurrentHashMap<String, Endpoint>();

    @Override
    public Endpoint create(String endpointName, Annotation endpointConfig, TestContext context) {
        String qualifier = endpointConfig.annotationType().getAnnotation(CitrusEndpointConfig.class).qualifier();
        Optional<AnnotationConfigParser> parser = Optional.ofNullable(context.getReferenceResolver().resolveAll(AnnotationConfigParser.class).get(qualifier));
        if (!parser.isPresent()) {
            parser = AnnotationConfigParser.lookup(qualifier);
        }
        if (parser.isPresent()) {
            Object endpoint = parser.get().parse(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint annotation parser with name '%s'", qualifier));
    }

    @Override
    public Endpoint create(String endpointName, CitrusEndpoint endpointConfig, Class<?> endpointType, TestContext context) {
        Optional<EndpointBuilder> builder = context.getReferenceResolver().resolveAll(EndpointBuilder.class).values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        if (builder.isPresent()) {
            Object endpoint = builder.get().build(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        Optional<EndpointBuilder> lookup = EndpointBuilder.lookup().values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        if (lookup.isPresent()) {
            Object endpoint = lookup.get().build(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint builder for type '%s'", endpointType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint create(String uri, TestContext context) {
        String endpointUri = context.replaceDynamicContentInString(uri);
        if (!endpointUri.contains(":")) {
            return context.getReferenceResolver().resolve(endpointUri, Endpoint.class);
        }
        StringTokenizer tok = new StringTokenizer(endpointUri, ":");
        if (tok.countTokens() < 2) {
            throw new CitrusRuntimeException(String.format("Invalid endpoint uri '%s'", endpointUri));
        }
        String componentName = tok.nextToken();
        Optional<EndpointComponent> component = Optional.ofNullable(this.getEndpointComponents(context.getReferenceResolver()).get(componentName));
        if (!component.isPresent()) {
            component = EndpointComponent.lookup(componentName);
        }
        if (!component.isPresent()) {
            throw new CitrusRuntimeException(String.format("Unable to create endpoint component with name '%s'", componentName));
        }
        Map<String, String> parameters = component.get().getParameters(endpointUri);
        String cachedEndpointName = parameters.containsKey("endpointName") ? parameters.remove("endpointName") : endpointUri;
        Map<String, Endpoint> map = this.endpointCache;
        synchronized (map) {
            if (this.endpointCache.containsKey(cachedEndpointName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found cached endpoint for uri '{}'", (Object)cachedEndpointName);
                }
                return this.endpointCache.get(cachedEndpointName);
            }
            Endpoint endpoint = component.get().createEndpoint(endpointUri, context);
            this.endpointCache.put(cachedEndpointName, endpoint);
            return endpoint;
        }
    }

    private Map<String, EndpointComponent> getEndpointComponents(ReferenceResolver referenceResolver) {
        return referenceResolver.resolveAll(EndpointComponent.class);
    }
}

