/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.report.TestActionListener;
import org.citrusframework.report.TestActionListenerAware;

public class TestActionListeners
implements TestActionListenerAware {
    private final List<TestActionListener> testActionListeners = new ArrayList<TestActionListener>();

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionFinish(testCase, testAction);
        }
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionSkipped(testCase, testAction);
        }
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionStart(testCase, testAction);
        }
    }

    @Override
    public void addTestActionListener(TestActionListener listener) {
        this.testActionListeners.add(listener);
    }

    public List<TestActionListener> getTestActionListeners() {
        return Collections.unmodifiableList(this.testActionListeners);
    }
}

