/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main;

import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TestEngine {
    public static final Logger logger = LoggerFactory.getLogger(TestEngine.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/engine";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/engine");

    public void run();

    public static TestEngine lookup(TestRunConfiguration configuration) {
        try {
            TestEngine testEngine = (TestEngine)TYPE_RESOLVER.resolve(configuration.getEngine(), configuration);
            logger.debug(String.format("Using Citrus engine '%s' as %s", configuration.getEngine(), testEngine));
            return testEngine;
        }
        catch (CitrusRuntimeException e) {
            throw new CitrusRuntimeException(String.format("Failed to resolve Citrus engine from resource '%s/%s'", RESOURCE_PATH, configuration.getEngine()), e);
        }
    }
}

