/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;

public abstract class AbstractMessageValidator<T extends ValidationContext>
implements MessageValidator<T> {
    @Override
    public final void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, List<ValidationContext> validationContexts) throws ValidationException {
        T validationContext = this.findValidationContext(validationContexts);
        if (validationContext != null) {
            this.validateMessage(receivedMessage, controlMessage, context, validationContext);
        }
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, T validationContext) {
    }

    protected abstract Class<T> getRequiredValidationContextType();

    public T findValidationContext(List<ValidationContext> validationContexts) {
        for (ValidationContext validationContext : validationContexts) {
            if (!this.getRequiredValidationContextType().isInstance(validationContext)) continue;
            return (T)validationContext;
        }
        return null;
    }
}

