/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TestResult {
    private final RESULT result;
    private final String testName;
    private final String className;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    @Nullable
    private Throwable cause;
    @Nullable
    private String errorMessage;
    @Nullable
    private String failureStack;
    @Nullable
    private String failureType;
    @Nullable
    private Duration duration;

    public static TestResult success(String name, String className) {
        return new TestResult(RESULT.SUCCESS, name, className);
    }

    public static TestResult success(String name, String className, Map<String, Object> parameters) {
        return new TestResult(RESULT.SUCCESS, name, className).withParameters(parameters);
    }

    public static TestResult skipped(String name, String className) {
        return new TestResult(RESULT.SKIP, name, className);
    }

    public static TestResult skipped(String name, String className, @Nonnull Map<String, Object> parameters) {
        return new TestResult(RESULT.SKIP, name, className).withParameters(parameters);
    }

    public static TestResult failed(String name, String className, @Nullable Throwable cause) {
        return new TestResult(RESULT.FAILURE, name, className).withCause(cause).withErrorMessage(Optional.ofNullable(cause).map(Throwable::getMessage).orElse(""));
    }

    public static TestResult failed(String name, String className, @Nonnull String errorMessage) {
        return new TestResult(RESULT.FAILURE, name, className).withErrorMessage(errorMessage);
    }

    public static TestResult failed(String name, String className, @Nullable Throwable cause, @Nonnull Map<String, Object> parameters) {
        return new TestResult(RESULT.FAILURE, name, className).withParameters(parameters).withCause(cause).withErrorMessage(Optional.ofNullable(cause).map(Throwable::getMessage).orElse(""));
    }

    TestResult(RESULT result, String testName, String className) {
        this.result = result;
        this.testName = testName;
        this.className = className;
    }

    public boolean isSuccess() {
        return RESULT.SUCCESS.equals((Object)this.result);
    }

    public boolean isFailed() {
        return RESULT.FAILURE.equals((Object)this.result);
    }

    public boolean isSkipped() {
        return RESULT.SKIP.equals((Object)this.result);
    }

    public String getResult() {
        return this.result.name();
    }

    public String getTestName() {
        return this.testName;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getFailureStack() {
        return this.failureStack;
    }

    @Nullable
    public String getFailureType() {
        return this.failureType;
    }

    public TestResult withFailureType(String failureType) {
        this.failureType = failureType;
        return this;
    }

    @Nullable
    public Duration getDuration() {
        return this.duration;
    }

    public TestResult withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    private TestResult withParameters(Map<String, Object> parameters) {
        this.parameters.putAll(parameters);
        return this;
    }

    private TestResult withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    private TestResult withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getSimpleName()).append("[").append("testName=").append(this.testName);
        if (!this.parameters.isEmpty()) {
            stringBuilder.append(", parameters=[").append(this.parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", "))).append("]");
        }
        stringBuilder.append(", result=").append((Object)this.result);
        if (Objects.nonNull(this.duration)) {
            stringBuilder.append(", durationMs=").append(this.duration.toMillis());
        }
        return stringBuilder.append("]").toString();
    }

    public static enum RESULT {
        SUCCESS,
        FAILURE,
        SKIP;

    }
}

