/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.citrusframework.TestResult;

public class TestResults {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat decFormat = new DecimalFormat("0.0");
    private static final String ZERO_PERCENTAGE = "0.0";
    private final Set<TestResult> results = Collections.synchronizedSet(new LinkedHashSet());

    public List<TestResult> asList() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        this.doWithResults(results::add);
        return results;
    }

    public boolean addResult(TestResult result) {
        return this.results.add(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWithResults(ResultCallback callback) {
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult result : this.results) {
                callback.doWithResult(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuccess() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isSuccess()) continue;
                ++count;
            }
        }
        return count;
    }

    public String getSuccessPercentage() {
        return this.results.size() > 0 ? decFormat.format((double)this.getSuccess() / (double)(this.getFailed() + this.getSuccess()) * 100.0) : ZERO_PERCENTAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailed() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isFailed()) continue;
                ++count;
            }
        }
        return count;
    }

    public String getFailedPercentage() {
        return this.results.size() > 0 ? decFormat.format((double)this.getFailed() / (double)(this.getFailed() + this.getSuccess()) * 100.0) : ZERO_PERCENTAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSkipped() {
        int count = 0;
        Set<TestResult> set = this.results;
        synchronized (set) {
            for (TestResult testResult : this.results) {
                if (!testResult.isSkipped()) continue;
                ++count;
            }
        }
        return count;
    }

    public String getSkippedPercentage() {
        return this.results.size() > 0 ? decFormat.format((double)this.getSkipped() / (double)this.results.size() * 100.0) : ZERO_PERCENTAGE;
    }

    public int getSize() {
        return this.results.size();
    }

    static {
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        symbol.setDecimalSeparator('.');
        decFormat.setDecimalFormatSymbols(symbol);
    }

    public static interface ResultCallback {
        public void doWithResult(TestResult var1);
    }
}

