/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

public class FailureStackElement {
    private String actionName;
    private String testFilePath;
    private Long lineNumberStart = 0L;
    private Long lineNumberEnd = 0L;

    public FailureStackElement(String testFilePath, String actionName, Long lineNumberStart) {
        this.testFilePath = testFilePath;
        this.actionName = actionName;
        this.lineNumberStart = lineNumberStart;
    }

    public String getStackMessage() {
        if (this.lineNumberEnd > 0L && !this.lineNumberStart.equals(this.lineNumberEnd)) {
            return "at " + this.testFilePath + "(" + this.actionName + ":" + this.lineNumberStart + "-" + this.lineNumberEnd + ")";
        }
        return "at " + this.testFilePath + "(" + this.actionName + ":" + this.lineNumberStart + ")";
    }

    public Long getLineNumberStart() {
        return this.lineNumberStart;
    }

    public void setLineNumberEnd(Long toLineNumber) {
        this.lineNumberEnd = toLineNumber;
    }

    public Long getLineNumberEnd() {
        return this.lineNumberEnd;
    }

    public String getTestFilePath() {
        return this.testFilePath;
    }
}

