/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.validation.DefaultMessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTextEqualsMessageValidator
extends DefaultMessageValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTextEqualsMessageValidator.class);
    private boolean normalizeLineEndings = true;
    private boolean trim = true;

    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) {
        if (controlMessage == null || controlMessage.getPayload() == null || controlMessage.getPayload(String.class).isEmpty()) {
            logger.debug("Skip message payload validation as no control message was defined");
            return;
        }
        logger.debug("Start to verify message payload ...");
        String controlPayload = controlMessage.getPayload(String.class);
        String receivedPayload = receivedMessage.getPayload(String.class);
        if (this.trim) {
            controlPayload = controlPayload.trim();
            receivedPayload = receivedPayload.trim();
        }
        if (this.normalizeLineEndings) {
            controlPayload = DefaultTextEqualsMessageValidator.normalizeLineEndings(controlPayload);
            receivedPayload = DefaultTextEqualsMessageValidator.normalizeLineEndings(receivedPayload);
        }
        if (!receivedPayload.equals(controlPayload)) {
            throw new ValidationException("Validation failed - message payload not equal!");
        }
    }

    public DefaultTextEqualsMessageValidator normalizeLineEndings() {
        this.normalizeLineEndings = true;
        return this;
    }

    public DefaultTextEqualsMessageValidator enableTrim() {
        this.trim = true;
        return this;
    }

    private static String normalizeLineEndings(String text) {
        return text.replace("\r\n", "\n").replace("&#13;", "");
    }
}

