/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TestResult {
    private final RESULT result;
    private final String testName;
    private final String className;
    private final Map<String, Object> parameters;
    private final Throwable cause;
    private final String errorMessage;
    private String failureStack;
    private String failureType;

    public static TestResult success(String name, String className) {
        return new TestResult(name, className, RESULT.SUCCESS);
    }

    public static TestResult success(String name, String className, Map<String, Object> parameters) {
        return new TestResult(name, className, RESULT.SUCCESS, parameters);
    }

    public static TestResult skipped(String name, String className) {
        return new TestResult(name, className, RESULT.SKIP);
    }

    public static TestResult skipped(String name, String className, Map<String, Object> parameters) {
        return new TestResult(name, className, RESULT.SKIP, parameters);
    }

    public static TestResult failed(String name, String className, Throwable cause) {
        return new TestResult(name, className, RESULT.FAILURE, cause);
    }

    public static TestResult failed(String name, String className, String errorMessage) {
        return new TestResult(name, className, RESULT.FAILURE, null, errorMessage);
    }

    public static TestResult failed(String name, String className, Throwable cause, Map<String, Object> parameters) {
        return new TestResult(name, className, RESULT.FAILURE, cause, parameters);
    }

    private TestResult(String name, String className, RESULT result) {
        this(name, className, result, new HashMap<String, Object>());
    }

    private TestResult(String name, String className, RESULT result, Map<String, Object> parameters) {
        this(name, className, result, null, parameters);
    }

    private TestResult(String name, String className, RESULT result, Throwable cause) {
        this(name, className, result, cause, new HashMap<String, Object>());
    }

    private TestResult(String name, String className, RESULT result, Throwable cause, String errorMessage) {
        this(name, className, result, cause, errorMessage, new HashMap<String, Object>());
    }

    private TestResult(String name, String className, RESULT result, Throwable cause, Map<String, Object> parameters) {
        this(name, className, result, cause, Optional.ofNullable(cause).map(Throwable::getMessage).orElse(""), parameters);
    }

    private TestResult(String name, String className, RESULT result, Throwable cause, String errorMessage, Map<String, Object> parameters) {
        this.testName = name;
        this.className = className;
        this.result = result;
        this.cause = cause;
        this.parameters = parameters;
        this.errorMessage = errorMessage;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.parameters != null && this.parameters.size() > 0) {
            builder.append(" ").append(this.testName).append("(").append(this.parameters.values().stream().map(Object::toString).collect(Collectors.joining(","))).append(") ");
        } else {
            builder.append(" ").append(this.testName).append(" ");
        }
        int spaces = 65 - builder.length();
        for (int i = 0; i < spaces; ++i) {
            builder.append(".");
        }
        switch (this.result) {
            case SUCCESS: {
                builder.append(" SUCCESS");
                break;
            }
            case SKIP: {
                builder.append(" SKIPPED");
                break;
            }
            case FAILURE: {
                builder.append(" FAILED");
                break;
            }
        }
        return builder.toString();
    }

    public boolean isSuccess() {
        return !this.isSkipped() && this.result != null && this.result.equals((Object)RESULT.SUCCESS);
    }

    public boolean isFailed() {
        return !this.isSkipped() && this.result != null && this.result.equals((Object)RESULT.FAILURE);
    }

    public boolean isSkipped() {
        return this.result != null && this.result.equals((Object)RESULT.SKIP);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getResult() {
        return this.result.name();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFailureType() {
        return this.failureType;
    }

    public void setFailureType(String failureType) {
        this.failureType = failureType;
    }

    public TestResult withFailureType(String failureType) {
        this.setFailureType(failureType);
        return this;
    }

    public String getFailureStack() {
        return this.failureStack;
    }

    public void setFailureStack(String failureStack) {
        this.failureStack = failureStack;
    }

    public TestResult withFailureStack(String failureStack) {
        this.setFailureStack(failureStack);
        return this;
    }

    private static enum RESULT {
        SUCCESS,
        FAILURE,
        SKIP;

    }
}

